/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.filter;

import com.bxm.adx.common.buy.buyers.BuyerWrapper;
import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.filter.Filter;
import com.bxm.adx.common.filter.FilterRequest;
import com.bxm.adx.common.market.MarketOrders;
import com.bxm.adx.common.market.MarketRequest;
import com.bxm.adx.facade.constant.enums.AdxErrEnum;
import com.bxm.adx.facade.exception.AdxException;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;

public abstract class AbstractDspFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(AbstractDspFilter.class);

    @Override
    public void filter(FilterRequest request) {
        MarketOrders marketOrders = request.getMarketOrders();
        if (marketOrders == null) {
            log.debug(" marketOrders is null . ");
            return;
        }
        List<Dispatcher> dsps = this.doFilter(marketOrders);
        this.removeDsp(dsps, marketOrders);
        if (CollectionUtils.isEmpty(marketOrders.getRequests())) {
            log.debug("after marketOrders MarketRequest is null . ");
            throw new AdxException(AdxErrEnum.POSITION_FILTER);
        }
    }

    protected abstract List<Dispatcher> doFilter(MarketOrders var1);

    protected void removeDsp(List<Dispatcher> dispatcherList, MarketOrders marketOrders) {
        List<MarketRequest> requests;
        if (CollectionUtils.isEmpty(dispatcherList)) {
            return;
        }
        if (log.isDebugEnabled()) {
            String clazzSimpleName = ClassUtils.getUserClass(this.getClass()).getSimpleName();
            log.debug("filter {} remove {}", (Object)clazzSimpleName, dispatcherList.stream().map(Dispatcher::getId).collect(Collectors.toSet()));
        }
        if (CollectionUtils.isEmpty(requests = marketOrders.getRequests())) {
            return;
        }
        Iterator<MarketRequest> iterator = requests.iterator();
        dispatcherList.forEach(dispatcher -> {
            while (iterator.hasNext()) {
                MarketRequest next = (MarketRequest)iterator.next();
                Iterator<BuyerWrapper> buyerWrapperIterator = next.getBuyers().iterator();
                while (buyerWrapperIterator.hasNext()) {
                    BuyerWrapper buyerWrapper = buyerWrapperIterator.next();
                    Dispatcher currentDispatcher = buyerWrapper.getDispatcher();
                    if (!dispatcher.getConfigId().equals(currentDispatcher.getConfigId()) || !dispatcher.getDspId().equals(currentDispatcher.getDspId())) continue;
                    log.debug("remove dspConfigId = {}, dspId = {}", (Object)dispatcher.getConfigId(), (Object)dispatcher.getDspId());
                    buyerWrapperIterator.remove();
                    if (next.getBuyers().size() != 0) continue;
                    iterator.remove();
                }
            }
        });
    }
}

