/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.filter;

import com.bxm.adx.common.filter.Filter;
import com.bxm.adx.common.filter.FilterRequest;
import com.bxm.adx.common.market.MarketOrders;
import com.bxm.adx.common.sell.position.Position;
import com.bxm.adx.facade.constant.enums.AdxErrEnum;
import com.bxm.adx.facade.exception.AdxException;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;

public abstract class AbstractPositionFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(AbstractPositionFilter.class);

    @Override
    public void filter(FilterRequest request) {
        MarketOrders marketOrders = request.getMarketOrders();
        if (marketOrders == null) {
            log.debug(" marketOrders is null . ");
            return;
        }
        if (CollectionUtils.isEmpty(marketOrders.getPositions())) {
            log.debug("before marketOrders Positions is null . ");
            return;
        }
        List<String> positions = this.doFilter(marketOrders);
        this.removePosition(positions, marketOrders);
        if (CollectionUtils.isEmpty(marketOrders.getPositions())) {
            log.debug("after marketOrders Positions is null . ");
            throw new AdxException(AdxErrEnum.POSITION_FILTER);
        }
    }

    protected abstract List<String> doFilter(MarketOrders var1);

    protected void removePosition(List<String> positions, MarketOrders marketOrders) {
        if (CollectionUtils.isEmpty(positions)) {
            return;
        }
        if (log.isDebugEnabled()) {
            String clazzSimpleName = ClassUtils.getUserClass(this.getClass()).getSimpleName();
            log.debug("filter {} remove {}", (Object)clazzSimpleName, positions);
        }
        Iterator<Position> iterator = marketOrders.getPositions().iterator();
        positions.forEach(position -> {
            while (iterator.hasNext()) {
                Position next = (Position)iterator.next();
                if (!next.getPositionId().equals(position)) continue;
                log.debug("remove positionid = {}", position);
                iterator.remove();
            }
        });
    }
}

