/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.log.dsplog;

import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.response.SeatBid;
import com.bxm.warcar.integration.distributed.DisableDistributed;
import com.bxm.warcar.utils.NamedThreadFactory;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class DspLogRecord
implements DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(DspLogRecord.class);
    private final ObjectMapper mapper = new ObjectMapper();
    private final Logger requestLogger = LoggerFactory.getLogger((String)(DspLogRecord.class.getName() + ".request"));
    private final Logger responseLogger = LoggerFactory.getLogger((String)(DspLogRecord.class.getName() + ".response"));
    private final ThreadPoolExecutor executor = new ThreadPoolExecutor(10, 20, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1000), (ThreadFactory)new NamedThreadFactory("dspLogResponse"), new ThreadPoolExecutor.CallerRunsPolicy());
    private final ConcurrentHashMap<String, Long> map = new ConcurrentHashMap();

    @PostConstruct
    public void init() {
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    public void dspLog(BidRequest request, BidResponse response, Dispatcher dispatcher) {
        try {
            this.logRequest(request);
            if (StringUtils.isEmpty((String)response.getId())) {
                response.setId(request.getId());
            }
            for (SeatBid seatBid : response.getSeat_bid()) {
                seatBid.setDspId(dispatcher.getDspId());
            }
            this.logResponse(response);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void logResponse(BidResponse obj) {
        if (obj == null) {
            return;
        }
        try {
            String s = this.mapper.writeValueAsString((Object)obj);
            this.executor.execute(() -> this.responseLogger.info(s));
        }
        catch (Exception e) {
            log.error("jackson json error", (Throwable)e);
        }
    }

    private void logRequest(BidRequest obj) {
        if (obj == null) {
            return;
        }
        if (this.map.containsKey(obj.getId())) {
            return;
        }
        this.map.put(obj.getId(), System.currentTimeMillis());
        try {
            String s = this.mapper.writeValueAsString((Object)obj);
            this.executor.execute(() -> this.requestLogger.info(s));
        }
        catch (Exception e) {
            log.error("jackson json error", (Throwable)e);
        }
    }

    @DisableDistributed
    @Scheduled(cron="*/1 * * * * ?")
    public void deleteExpireKey() {
        long l = System.currentTimeMillis();
        for (Map.Entry<String, Long> entry : this.map.entrySet()) {
            if (l - entry.getValue() <= 1000L) continue;
            this.map.remove(entry.getKey());
        }
    }

    public void destroy() {
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

