/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.exchange;

import com.bxm.adx.common.adapter.AdxContextFactory;
import com.bxm.adx.common.buy.buyers.BuyerWrapper;
import com.bxm.adx.common.market.MarketOrders;
import com.bxm.adx.common.market.MarketRequest;
import com.bxm.adx.common.market.exchange.ExchangeResult;
import com.bxm.adx.common.market.exchange.Exchanger;
import com.bxm.adx.common.market.exchange.PriorityExchanger;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.position.Position;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DefaultPriorityExchanger
implements PriorityExchanger {
    private static final Logger log = LoggerFactory.getLogger(DefaultPriorityExchanger.class);
    private final Exchanger exchanger;

    public DefaultPriorityExchanger(Exchanger exchanger) {
        this.exchanger = exchanger;
    }

    @Override
    public ExchangeResult exchange(MarketOrders orders) {
        BidRequest request = orders.getBidRequest();
        List<MarketRequest> requestList = orders.getRequests();
        if (CollectionUtils.isEmpty(requestList)) {
            return null;
        }
        ExchangeResult exchangeResult = new ExchangeResult();
        for (MarketRequest marketRequest : requestList) {
            Set<BuyerWrapper> buyers = marketRequest.getBuyers();
            Set<Position> positions = marketRequest.getPositions();
            HashSet positionIds = Sets.newHashSet();
            for (Position position : positions) {
                positionIds.add(position.getPositionId());
                positionIds.add(position.getAppPositionId());
            }
            ArrayList imps = Lists.newArrayList(request.getImps());
            imps.removeIf(impression -> !positionIds.contains(impression.getTag_id()));
            BidRequest e = new BidRequest();
            BeanUtils.copyProperties((Object)request, (Object)e);
            e.setImps(imps);
            ExchangeResult result = this.exchanger.bidding(e, buyers);
            if (Objects.nonNull(result)) {
                exchangeResult.getDeals().addAll(result.getDeals());
                exchangeResult.addTrash(result.getTrash());
                exchangeResult.getBuyers().addAll(result.getBuyers());
            }
            if (AdxContextFactory.get().isOptimization() || !exchangeResult.exchangeSuccess()) continue;
            return exchangeResult;
        }
        return exchangeResult;
    }
}

