/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.exchange;

import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.DspThreadPoolProperties;
import com.bxm.adx.common.buy.buyers.BuyerWrapper;
import com.bxm.adx.common.buy.cache.BuyerResponseCache;
import com.bxm.adx.common.buy.dsp.Dsp;
import com.bxm.adx.common.log.datalog.DataLogDao;
import com.bxm.adx.common.log.dsplog.DspLogRecord;
import com.bxm.adx.common.market.Deal;
import com.bxm.adx.common.market.exchange.CustomRejected;
import com.bxm.adx.common.market.exchange.ExchangeCacheCallable;
import com.bxm.adx.common.market.exchange.ExchangeCallable;
import com.bxm.adx.common.market.exchange.ExchangeResult;
import com.bxm.adx.common.market.exchange.Exchanger;
import com.bxm.adx.common.market.exchange.rebuild.request.AdxBidRequestBuildFactory;
import com.bxm.adx.common.market.exchange.rebuild.request.RequestBuildAttribute;
import com.bxm.adx.common.market.exchange.rebuild.response.AdxBidResponseBuildFactory;
import com.bxm.adx.common.market.filter.DealFilterFactory;
import com.bxm.adx.common.micrometer.BuyerMeter;
import com.bxm.adx.common.micrometer.ExchangeCallableMeter;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.rebuild.request.RebuildRequestChain;
import com.bxm.warcar.integration.eventbus.EventPark;
import com.bxm.warcar.utils.NamedThreadFactory;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;

@Configuration
public class RtbExchanger
implements Exchanger,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(RtbExchanger.class);
    private final BuyerMeter buyerMeter;
    private final ExchangeCallableMeter exchangeCallableMeter;
    private final EventPark eventPark;
    private final BuyerResponseCache buyerResponseCache;
    private final DataLogDao dataLogDao;
    private final ThreadPoolExecutor executor;
    private final DspLogRecord dspLogRecord;
    private final RebuildRequestChain requestChain;
    private final AdxBidRequestBuildFactory factory;
    private final AdxBidResponseBuildFactory responseBuildFactory;
    private final DealFilterFactory dealFilterFactory;

    public RtbExchanger(BuyerMeter buyerMeter, ExchangeCallableMeter exchangeCallableMeter, EventPark eventPark, BuyerResponseCache buyerResponseCache, DataLogDao dataLogDao, CustomRejected customRejected, AdxProperties adxProperties, DspLogRecord dspLogRecord, RebuildRequestChain requestChain, AdxBidRequestBuildFactory factory, AdxBidResponseBuildFactory responseBuildFactory, DealFilterFactory dealFilterFactory) {
        this.buyerMeter = buyerMeter;
        this.exchangeCallableMeter = exchangeCallableMeter;
        this.eventPark = eventPark;
        this.buyerResponseCache = buyerResponseCache;
        this.dataLogDao = dataLogDao;
        this.dspLogRecord = dspLogRecord;
        this.requestChain = requestChain;
        this.factory = factory;
        this.responseBuildFactory = responseBuildFactory;
        this.dealFilterFactory = dealFilterFactory;
        DspThreadPoolProperties dspThreadPool = adxProperties.getDspThreadPool();
        this.executor = new ThreadPoolExecutor(dspThreadPool.getCoreCount(), dspThreadPool.getMaxCount(), dspThreadPool.getLiveTime().intValue(), TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(dspThreadPool.getQueueLength()), (ThreadFactory)new NamedThreadFactory("exchange"), customRejected);
    }

    @Override
    public ExchangeResult bidding(BidRequest bidRequest, Collection<BuyerWrapper> buyers) {
        ExchangeResult result = new ExchangeResult();
        result.getBuyers().addAll(buyers);
        if (0 == buyers.size() || null == bidRequest) {
            return result;
        }
        ArrayList futures = Lists.newArrayList();
        CountDownLatch waitCountDown = new CountDownLatch(buyers.size());
        CountDownLatch overtimeCountDown = new CountDownLatch(1);
        for (BuyerWrapper buyer : buyers) {
            BidRequest adxBidRequest = this.factory.buildAdxBidRequest(bidRequest, RequestBuildAttribute.builder().buyerWrapper(buyer).build());
            futures.add(this.executor.submit(new ExchangeCallable(buyer, bidRequest, adxBidRequest, this.buyerMeter, this.eventPark, this.buyerResponseCache, waitCountDown, overtimeCountDown, this.dataLogDao, this.dspLogRecord, this.requestChain, this.responseBuildFactory, this.exchangeCallableMeter)));
            Dsp dsp = buyer.getBuyer().getDsp();
            Long cacheTime = dsp.getCacheTime();
            if (Objects.isNull(cacheTime) || cacheTime.intValue() == 0) continue;
            futures.add(this.executor.submit(new ExchangeCacheCallable(bidRequest, buyer, this.buyerResponseCache, this.exchangeCallableMeter)));
        }
        this.waitDealFilter(result, waitCountDown, bidRequest.getWaitTime(), futures);
        if (!CollectionUtils.isEmpty(result.getDeals())) {
            return result;
        }
        if (futures.size() == 0) {
            return result;
        }
        this.waitDealFilter(result, overtimeCountDown, bidRequest.getOvertime() - bidRequest.getWaitTime(), futures);
        return result;
    }

    private void waitDealFilter(ExchangeResult result, CountDownLatch waitCountDown, Long waitTime, List<Future<Deal>> dealList) {
        try {
            waitCountDown.await(waitTime, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            log.error("countDown err", (Throwable)e);
            return;
        }
        ArrayList deals = Lists.newArrayList();
        Iterator<Future<Deal>> iterator = dealList.iterator();
        while (iterator.hasNext()) {
            Future<Deal> future = iterator.next();
            try {
                if (!future.isDone()) continue;
                Deal response = future.get();
                if (null != response) {
                    deals.add(response);
                }
                iterator.remove();
            }
            catch (InterruptedException | ExecutionException e) {
                future.cancel(true);
                log.error("execute: ", (Throwable)e);
            }
        }
        Map<Integer, Set<Deal>> trashMap = this.dealFilterFactory.filterDeals(deals, true);
        result.getDeals().addAll(deals);
        result.addTrash(trashMap);
    }

    public void destroy() {
        this.executor.shutdown();
    }
}

