/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.exchange.rebuild.offer;

import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dispatcher.DispatcherPriceConfig;
import com.bxm.adx.common.market.exchange.rebuild.offer.Offer;
import com.bxm.adx.common.market.exchange.rebuild.offer.OfferResult;
import com.bxm.adx.common.market.exchange.rebuild.offer.OfferType;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.response.Bid;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.springframework.context.annotation.Configuration;

@Configuration
public class NoneDspAvgPriceOffer
implements Offer {
    @Override
    public Map<Bid, OfferResult> offer(Collection<Bid> bids, BidRequest request, Dispatcher dispatcher) {
        HashMap<Bid, OfferResult> offerResultMap = new HashMap<Bid, OfferResult>(bids.size());
        for (Bid bid : bids) {
            BigDecimal offer = this.getPriceByConfig(bid, request, dispatcher);
            offerResultMap.put(bid, OfferResult.builder().offer(offer).chargeType(1).build());
        }
        return offerResultMap;
    }

    @Override
    public OfferType offerType() {
        return OfferType.NONE_Dsp_Avg_Price;
    }

    private BigDecimal getPriceByConfig(Bid bid, BidRequest bidRequest, Dispatcher dispatcher) {
        BigDecimal bidFloor;
        BigDecimal profitMargin;
        DispatcherPriceConfig config = dispatcher.getDispatcherPriceConfig();
        if (Objects.isNull(config)) {
            return bid.getPrice();
        }
        BigDecimal dspWinPrice = bid.getDspWinPrice();
        BigDecimal newPrice = dspWinPrice.multiply(new BigDecimal(100.0).subtract(profitMargin = Optional.ofNullable(config.getProfitMargin()).orElse(BigDecimal.ZERO))).multiply(config.getBiddingCoefficient()).movePointLeft(2);
        if (newPrice.compareTo(bidFloor = bidRequest.getImps().iterator().next().getBid_floor()) >= 0) {
            return newPrice.setScale(0, RoundingMode.HALF_UP);
        }
        BigDecimal explorePrice = bidFloor.add(BigDecimal.ONE);
        if (dspWinPrice.compareTo(explorePrice) >= 0) {
            return explorePrice.setScale(0, RoundingMode.HALF_UP);
        }
        return null;
    }

    @Deprecated
    private BigDecimal maxBidFloor(BidRequest bidRequest, Dispatcher dispatcher) {
        BigDecimal dispatcherBidFloor = Optional.ofNullable(dispatcher.getDspBasePrice()).orElse(BigDecimal.ZERO).movePointRight(2);
        BigDecimal bidFloor = bidRequest.getImps().iterator().next().getBid_floor();
        int result = bidFloor.compareTo(dispatcherBidFloor);
        switch (result) {
            case -1: {
                return dispatcherBidFloor;
            }
        }
        return bidFloor;
    }
}

