/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.exchange.rebuild.request;

import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.position.AdvertPoint;
import com.bxm.adx.common.buy.position.AdvertPointService;
import com.bxm.adx.common.market.exchange.rebuild.request.AdxBidRequestBuilder;
import com.bxm.adx.common.market.exchange.rebuild.request.RequestBuildAttribute;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.request.App;
import com.bxm.warcar.integration.pair.Pair;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AppBuilder
implements AdxBidRequestBuilder {
    private final AdvertPointService advertPointService;
    private final Pair pair;
    private static final String KEY = "adx.app.package.dsp.list";

    public AppBuilder(AdvertPointService advertPointService, Pair pair) {
        this.advertPointService = advertPointService;
        this.pair = pair;
    }

    @Override
    public void rebuildAdxBidRequest(BidRequest adxBidRequest, RequestBuildAttribute attribute) {
        Dispatcher dispatcher = attribute.getBuyerWrapper().getDispatcher();
        AdvertPoint advertPoint = this.advertPointService.getAdvertPointByDspId(dispatcher.getDspId().toString(), dispatcher.getDspAppid(), dispatcher.getDspPosid());
        App app = new App();
        if (Objects.nonNull(adxBidRequest.getApp())) {
            BeanUtils.copyProperties((Object)adxBidRequest.getApp(), (Object)app);
        }
        app.setId(dispatcher.getDspAppid());
        this.setAppPackageName(app, dispatcher);
        if (Objects.nonNull(advertPoint)) {
            app.setVer(advertPoint.getVersion());
            app.setName(advertPoint.getAppName());
        }
        adxBidRequest.setApp(app);
    }

    private void setAppPackageName(App app, Dispatcher dispatcher) {
        String dspId;
        Set dspIds = this.pair.get(KEY).ofHashSet();
        if (CollectionUtils.isNotEmpty((Collection)dspIds) && dspIds.contains(dspId = String.valueOf(dispatcher.getDspId()))) {
            return;
        }
        if (StringUtils.isNotEmpty((String)dispatcher.getAppPackageName())) {
            app.setBundle(dispatcher.getAppPackageName());
        }
    }
}

