/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.exchange.rebuild.request;

import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dispatcher.DispatcherPriceConfig;
import com.bxm.adx.common.market.exchange.rebuild.request.AdxBidRequestBuilder;
import com.bxm.adx.common.market.exchange.rebuild.request.RequestBuildAttribute;
import com.bxm.adx.common.sell.BidRequest;
import java.math.BigDecimal;
import java.util.Objects;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RequestBuilder
implements AdxBidRequestBuilder {
    @Override
    public void rebuildAdxBidRequest(BidRequest adxBidRequest, RequestBuildAttribute attribute) {
        Dispatcher dispatcher = attribute.getBuyerWrapper().getDispatcher();
        adxBidRequest.setDspPriceCoefficient(this.getDspPriceCoefficient(dispatcher));
    }

    private Double getDspPriceCoefficient(Dispatcher dispatcher) {
        DispatcherPriceConfig config = dispatcher.getDispatcherPriceConfig();
        if (Objects.isNull(config)) {
            return null;
        }
        BigDecimal coeff = config.getBiddingCoefficient();
        if (Objects.nonNull(coeff)) {
            return coeff.doubleValue();
        }
        return null;
    }
}

