/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.exchange.rebuild.response;

import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.market.exchange.rebuild.offer.OfferFactory;
import com.bxm.adx.common.market.exchange.rebuild.offer.OfferResult;
import com.bxm.adx.common.market.exchange.rebuild.response.AdxBidResponseBuilder;
import com.bxm.adx.common.market.exchange.rebuild.response.ResponseBuildAttribute;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.SeatBid;
import java.util.Map;
import org.springframework.context.annotation.Configuration;

@Configuration
public class OfferPriceBuilder
implements AdxBidResponseBuilder {
    private final OfferFactory factory;

    public OfferPriceBuilder(OfferFactory factory) {
        this.factory = factory;
    }

    public int getOrder() {
        return 4;
    }

    @Override
    public void rebuildAdxBidResponse(BidResponse bidResponse, ResponseBuildAttribute attribute) {
        Dispatcher dispatcher = attribute.getDispatcher();
        BidRequest request = attribute.getBidRequest();
        for (SeatBid seatBid : bidResponse.getSeat_bid()) {
            Map<Bid, OfferResult> offerResultMap = this.factory.offer(seatBid.getBid(), request, dispatcher);
            block5: for (Bid bid : seatBid.getBid()) {
                OfferResult result = offerResultMap.get(bid);
                int chargeType = result.getChargeType();
                bid.setCharge_type(chargeType);
                switch (chargeType) {
                    case 1: {
                        bid.setPrice(result.getOffer());
                        continue block5;
                    }
                    case 2: {
                        bid.setBid(result.getOffer());
                        continue block5;
                    }
                }
                bid.setPrice(result.getOffer());
            }
        }
    }
}

