/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.monitor;

import com.bxm.adx.common.market.monitor.MonitorHandler;
import com.bxm.adx.common.report.ReportType;
import com.bxm.adx.common.report.ServerReportConfig;
import com.bxm.adx.common.report.ServerReportService;
import com.bxm.adx.common.sell.builder.BuildAttribute;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.ClickMonitor;
import com.bxm.adx.common.sell.response.ImpMonitor;
import com.google.common.collect.Lists;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriComponentsBuilder;

public class ServerReportHandler
implements MonitorHandler {
    private static final Logger log = LoggerFactory.getLogger(ServerReportHandler.class);
    private final ServerReportService serverReportService;
    private final Pattern pattern = Pattern.compile("(?<=\\.)[^.]+\\.[^.]+$");

    public ServerReportHandler(ServerReportService serverReportService) {
        this.serverReportService = serverReportService;
    }

    public int getOrder() {
        return 0;
    }

    @Override
    public void handler(Bid bid, BuildAttribute attribute) {
        List<ClickMonitor> clickMonitors;
        List<String> clickUrls;
        ServerReportConfig config = this.serverReportService.getConfig(attribute.getMediaId(), attribute.getAppId(), attribute.getDspId(), attribute.getSspRequest().getId());
        if (Objects.isNull(config)) {
            return;
        }
        int limit = config.getLimit();
        List<ImpMonitor> impMonitors = bid.getImp_monitors();
        List<String> impUrls = this.getImpUrls(impMonitors);
        if (this.isExceed(impUrls, limit)) {
            List<String> exceedImp = this.getExceed(impUrls, config, ReportType.IMP);
            impMonitors.removeIf(impMonitor -> exceedImp.contains(impMonitor.getImp_monitor_url()));
        }
        if (this.isExceed(clickUrls = this.getClickUrls(clickMonitors = bid.getClick_monitors()), limit)) {
            List<String> exceedClick = this.getExceed(clickUrls, config, ReportType.CLICK);
            clickMonitors.removeIf(clickMonitor -> exceedClick.contains(clickMonitor.getClick_monitor_url()));
        }
    }

    private List<String> getImpUrls(List<ImpMonitor> impMonitors) {
        if (CollectionUtils.isEmpty(impMonitors)) {
            return Lists.newArrayList();
        }
        List<String> urls = impMonitors.stream().filter(impMonitor -> StringUtils.isNotEmpty((CharSequence)impMonitor.getImp_monitor_url())).map(ImpMonitor::getImp_monitor_url).collect(Collectors.toList());
        return urls;
    }

    private List<String> getClickUrls(List<ClickMonitor> clickMonitors) {
        if (CollectionUtils.isEmpty(clickMonitors)) {
            return Lists.newArrayList();
        }
        List<String> urls = clickMonitors.stream().filter(clickMonitor -> StringUtils.isNotEmpty((CharSequence)clickMonitor.getClick_monitor_url())).map(ClickMonitor::getClick_monitor_url).collect(Collectors.toList());
        return urls;
    }

    private boolean isExceed(List<String> urls, int limit) {
        return urls.size() - limit > 0;
    }

    private List<String> getExceed(List<String> urls, ServerReportConfig config, ReportType type) {
        List<String> domains = config.getDomains();
        if (CollectionUtils.isNotEmpty(domains)) {
            urls.sort(this.comparator(domains));
        }
        List<String> exceed = urls.subList(config.getLimit(), urls.size());
        this.serverReportService.saveExceed(type, config.getBidId(), exceed);
        return exceed;
    }

    private Comparator<String> comparator(final List<String> domains) {
        return new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                String domain1 = ServerReportHandler.this.getDomain(UriComponentsBuilder.fromUriString((String)o1).build().getHost());
                String domain2 = ServerReportHandler.this.getDomain(UriComponentsBuilder.fromUriString((String)o2).build().getHost());
                boolean b1 = domains.contains(domain1);
                boolean b2 = domains.contains(domain2);
                if (b1) {
                    if (b2) {
                        return 0;
                    }
                    return -1;
                }
                if (b2) {
                    return 1;
                }
                return 0;
            }
        };
    }

    private String getDomain(String host) {
        Matcher matcher = this.pattern.matcher(host);
        if (matcher.find()) {
            String domain = matcher.group();
            return domain;
        }
        return "";
    }
}

