/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.nbr;

import com.bxm.adx.common.CacheKeys;
import com.bxm.adx.common.DeviceCrowdPackageJedisProperties;
import com.bxm.adx.common.buy.Buyer;
import com.bxm.adx.common.buy.dsp.Dsp;
import com.bxm.adx.common.limiter.InsertExpireHandler;
import com.bxm.adx.common.market.Deal;
import com.bxm.adx.common.market.nbr.NoBidResponseHandler;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.warcar.cache.KeyGenerator;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockDeviceHandler
implements NoBidResponseHandler {
    private static final Logger log = LoggerFactory.getLogger(BlockDeviceHandler.class);
    private final InsertExpireHandler insertExpireHandler;
    private final DeviceCrowdPackageJedisProperties properties;

    public BlockDeviceHandler(InsertExpireHandler insertExpireHandler, DeviceCrowdPackageJedisProperties properties) {
        this.insertExpireHandler = insertExpireHandler;
        this.properties = properties;
    }

    @Override
    public void handler(Deal ... deals) {
        if (ArrayUtils.isEmpty((Object[])deals)) {
            return;
        }
        KeyGenerator key = this.keyGenerator(deals);
        if (Objects.isNull(key)) {
            return;
        }
        Map<String, String> blockConfigs = this.properties.getBlockCrowdPackConfigs();
        for (Deal deal : deals) {
            long keyExpire;
            Long expireVal;
            String crowdPackId = this.getCrowdPackId(deal, blockConfigs);
            if (StringUtils.isBlank((String)crowdPackId) || Objects.isNull(expireVal = deal.getBidResponse().getCdt()) || (keyExpire = expireVal - System.currentTimeMillis() / 1000L) <= 0L) continue;
            this.insertExpireHandler.insert(key, crowdPackId, String.valueOf(expireVal), (int)(keyExpire += (long)RandomUtils.nextInt((int)1, (int)600)));
        }
    }

    @Override
    public int nbr() {
        return 40001;
    }

    private String getCrowdPackId(Deal deal, Map<String, String> blockConfigs) {
        Buyer buyer = deal.getBuyer();
        if (Objects.nonNull(buyer)) {
            Dsp dsp = buyer.getDsp();
            String dspCode = dsp.getDspCode();
            return blockConfigs.get(dspCode);
        }
        return null;
    }

    private KeyGenerator keyGenerator(Deal ... deals) {
        for (Deal deal : deals) {
            BidRequest request = deal.getBidRequest();
            if (!Objects.nonNull(request)) continue;
            return CacheKeys.getCrowdPackageNewKey(request.getDevice());
        }
        return null;
    }
}

