/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.nbr;

import com.bxm.adx.common.market.Deal;
import com.bxm.adx.common.market.exchange.ExchangeResult;
import com.bxm.adx.common.market.nbr.NoBidResponseHandler;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.utils.MapHelper;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class NoBidResponseService
implements ApplicationListener<ApplicationReadyEvent> {
    private static final Logger log = LoggerFactory.getLogger(NoBidResponseService.class);
    private Map<Integer, ? extends NoBidResponseHandler> handlers;

    public void onApplicationEvent(ApplicationReadyEvent event) {
        ConfigurableApplicationContext context = event.getApplicationContext();
        Map handlerMap = context.getBeansOfType(NoBidResponseHandler.class);
        if (CollectionUtils.isEmpty((Map)handlerMap)) {
            log.info("noBidResponse-handler empty");
            return;
        }
        this.handlers = handlerMap.values().stream().collect(Collectors.toMap(NoBidResponseHandler::nbr, noBidResponseHandler -> noBidResponseHandler));
    }

    public void handler(ExchangeResult exchangeResult) {
        if (CollectionUtils.isEmpty(this.handlers)) {
            return;
        }
        Map<Integer, Set<Deal>> trash = exchangeResult.getTrash();
        if (CollectionUtils.isEmpty(trash)) {
            return;
        }
        HashMap nbrDeals = Maps.newHashMap();
        for (Set<Deal> deals : trash.values()) {
            for (Deal deal : deals) {
                Integer nbr;
                BidResponse response = deal.getBidResponse();
                if (Objects.isNull(response) || Objects.isNull(nbr = response.getNbr())) continue;
                ((Set)MapHelper.get(nbrDeals, nbr, new HashSet())).add(deal);
            }
        }
        nbrDeals.forEach((k, v) -> {
            NoBidResponseHandler handler = this.handlers.get(k);
            if (Objects.nonNull(handler)) {
                handler.handler(v.toArray(new Deal[0]));
            }
        });
    }
}

