/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.micrometer;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ExchangeCallableMeter
implements MeterBinder {
    private static final Logger log = LoggerFactory.getLogger(ExchangeCallableMeter.class);
    private Timer exchangeCacheTimer;
    private Timer exchangeTimer;

    public void bindTo(MeterRegistry registry) {
        this.exchangeCacheTimer = Timer.builder((String)"call.cache").tag("name", this.getClass().getName()).register(registry);
        this.exchangeTimer = Timer.builder((String)"call").tag("name", this.getClass().getName()).register(registry);
    }

    public void recordCacheExchange(long start) {
        if (Objects.nonNull(this.exchangeCacheTimer)) {
            this.exchangeCacheTimer.record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
    }

    public void recordExchange(long start) {
        if (Objects.nonNull(this.exchangeTimer)) {
            this.exchangeTimer.record(System.currentTimeMillis() - start, TimeUnit.MILLISECONDS);
        }
    }
}

