/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.micrometer.aspect;

import com.bxm.adx.common.market.exchange.Exchanger;
import com.google.common.collect.Maps;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;

public class ExchangeMicroMeter
implements MeterBinder {
    private static final Logger log = LoggerFactory.getLogger(ExchangeMicroMeter.class);
    private final Map<Class, Timer> timers = Maps.newConcurrentMap();
    private final Map<Class, Counter> counters = Maps.newConcurrentMap();
    private final Iterable<Exchanger> exchangers;

    public ExchangeMicroMeter(Iterable<Exchanger> exchangers) {
        this.exchangers = exchangers;
    }

    public void bindTo(MeterRegistry registry) {
        for (Exchanger exchanger : this.exchangers) {
            Class clazz = ClassUtils.getUserClass((Object)exchanger);
            Timer timer = Timer.builder((String)"exchange.timer").tag("name", clazz.getName()).register(registry);
            this.timers.put(clazz, timer);
            Counter counter = Counter.builder((String)"exchange.buyer.counter").tag("name", clazz.getName()).register(registry);
            this.counters.put(clazz, counter);
            log.info("Registering exchange {} meter successful.", (Object)exchanger);
        }
    }

    Timer getTimer(Exchanger exchanger) {
        return this.timers.get(ClassUtils.getUserClass((Object)exchanger));
    }

    Counter getCounter(Exchanger exchanger) {
        return this.counters.get(ClassUtils.getUserClass((Object)exchanger));
    }
}

