/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.rule;

import com.bxm.adx.common.rule.Rule;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public class WhiteAndBlackRule {
    private static final String TYPE_SPLIT = "&";
    private static final String SPLIT = ",";
    private final Rule rule;
    private final String typeSeparatorChars;
    private final String separatorChars;

    public WhiteAndBlackRule(Rule rule) {
        this(rule, TYPE_SPLIT, SPLIT);
    }

    public WhiteAndBlackRule(Rule rule, String typeSeparatorChars, String separatorChars) {
        this.rule = rule;
        this.typeSeparatorChars = typeSeparatorChars;
        this.separatorChars = separatorChars;
    }

    public WhiteAndBlack getWhiteAndBlack() {
        Object black;
        String ruleVal = this.rule.ruleValue;
        if (StringUtils.isBlank((String)ruleVal)) {
            return null;
        }
        Object[] array = ruleVal.split(this.typeSeparatorChars);
        if (ArrayUtils.isEmpty((Object[])array) || array.length < 1) {
            return null;
        }
        WhiteAndBlack whiteAndBlack = new WhiteAndBlack();
        Object white = array[0];
        if (StringUtils.isNotBlank((String)white)) {
            whiteAndBlack.getWhite().addAll(Sets.newHashSet((Object[])((String)white).split(this.separatorChars)));
        }
        Object object = black = array.length > 1 ? array[1] : null;
        if (StringUtils.isNotBlank((String)black)) {
            whiteAndBlack.getBlack().addAll(Sets.newHashSet((Object[])((String)black).split(this.separatorChars)));
        }
        return whiteAndBlack;
    }

    public static class WhiteAndBlack {
        private Set<String> white = Sets.newHashSet();
        private Set<String> black = Sets.newHashSet();

        public Set<String> getAll() {
            HashSet<String> all = new HashSet<String>();
            all.addAll(this.white);
            all.addAll(this.black);
            return all;
        }

        public Set<String> getWhite() {
            return this.white;
        }

        public Set<String> getBlack() {
            return this.black;
        }

        public void setWhite(Set<String> white) {
            this.white = white;
        }

        public void setBlack(Set<String> black) {
            this.black = black;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WhiteAndBlack)) {
                return false;
            }
            WhiteAndBlack other = (WhiteAndBlack)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Set<String> this$white = this.getWhite();
            Set<String> other$white = other.getWhite();
            if (this$white == null ? other$white != null : !((Object)this$white).equals(other$white)) {
                return false;
            }
            Set<String> this$black = this.getBlack();
            Set<String> other$black = other.getBlack();
            return !(this$black == null ? other$black != null : !((Object)this$black).equals(other$black));
        }

        protected boolean canEqual(Object other) {
            return other instanceof WhiteAndBlack;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Set<String> $white = this.getWhite();
            result = result * 59 + ($white == null ? 43 : ((Object)$white).hashCode());
            Set<String> $black = this.getBlack();
            result = result * 59 + ($black == null ? 43 : ((Object)$black).hashCode());
            return result;
        }

        public String toString() {
            return "WhiteAndBlackRule.WhiteAndBlack(white=" + this.getWhite() + ", black=" + this.getBlack() + ")";
        }
    }
}

