/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.sell;

import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.adapter.AdxContextFactory;
import com.bxm.adx.common.adapter.BidModelAdapter;
import com.bxm.adx.common.buy.buyers.BuyerWrapper;
import com.bxm.adx.common.buy.buyers.PriorityBuyers;
import com.bxm.adx.common.market.MarketOrders;
import com.bxm.adx.common.market.MarketRequest;
import com.bxm.adx.common.openlog.event.internal.MediaRequestEvent;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidRequestWrapper;
import com.bxm.adx.common.sell.init.BidRequestInitializer;
import com.bxm.adx.common.sell.init.InitializerParam;
import com.bxm.adx.common.sell.position.Position;
import com.bxm.adx.common.sell.position.mapping.PositionMappingStrategyFactory;
import com.bxm.adx.common.sell.request.Device;
import com.bxm.adx.common.sell.request.Impression;
import com.bxm.adx.facade.constant.enums.AdxErrEnum;
import com.bxm.adx.facade.exception.AdxException;
import com.bxm.user.id.generator.DeviceHelper;
import com.bxm.user.id.generator.DeviceInfo;
import com.bxm.warcar.integration.eventbus.EventPark;
import com.bxm.warcar.utils.JsonHelper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Configuration
public class DefaultBidRequestWrapper
implements BidRequestWrapper,
ApplicationListener<ApplicationReadyEvent> {
    private static final Logger log = LoggerFactory.getLogger(DefaultBidRequestWrapper.class);
    private final PriorityBuyers priorityBuyers;
    private final AdxProperties properties;
    private final PositionMappingStrategyFactory positionMappingStrategyFactory;
    private final EventPark eventPark;
    private List<BidRequestInitializer> initializers = Lists.newArrayList();

    public DefaultBidRequestWrapper(PriorityBuyers priorityBuyers, AdxProperties properties, PositionMappingStrategyFactory positionMappingStrategyFactory, EventPark eventPark) {
        this.priorityBuyers = priorityBuyers;
        this.properties = properties;
        this.positionMappingStrategyFactory = positionMappingStrategyFactory;
        this.eventPark = eventPark;
    }

    public void onApplicationEvent(ApplicationReadyEvent event) {
        this.initializers.addAll(event.getApplicationContext().getBeansOfType(BidRequestInitializer.class).values());
        this.initializers.sort(Comparator.comparingInt(Ordered::getOrder));
    }

    @Override
    public MarketOrders packing(BidModelAdapter adapter, BidRequest bidRequest) {
        List<Impression> imps = bidRequest.getImps();
        if (CollectionUtils.isEmpty(imps)) {
            throw new AdxException(AdxErrEnum.POSITION_NOT_FOUND);
        }
        Impression impression = bidRequest.getImps().iterator().next();
        Position mediaPosition = this.positionMappingStrategyFactory.getPosition(bidRequest, impression);
        if (Objects.isNull(mediaPosition)) {
            throw new AdxException(AdxErrEnum.POSITION_NOT_FOUND);
        }
        AdxContextFactory.get().setBidRequest(bidRequest);
        String uid = this.getUid(bidRequest);
        bidRequest = adapter.reBuildBidRequest(bidRequest, mediaPosition);
        if (bidRequest == null) {
            return null;
        }
        HashMap positionListMap = Maps.newHashMap();
        ArrayList<Position> positionList = new ArrayList<Position>();
        if (Objects.nonNull(mediaPosition) && mediaPosition.isEnabled()) {
            positionList.add(mediaPosition);
            AdxContextFactory.get().setPosition(mediaPosition);
            BidRequest finalBidRequest = bidRequest;
            this.initializers.forEach(init -> init.accept(finalBidRequest, InitializerParam.builder().position(mediaPosition).build()));
            this.eventPark.post((EventObject)new MediaRequestEvent(this, bidRequest, mediaPosition));
            List<List<BuyerWrapper>> buyers = this.priorityBuyers.findAsPriority(mediaPosition, bidRequest);
            this.priorityBuyers.rebuildBuyers(bidRequest, mediaPosition, buyers);
            positionListMap.put(mediaPosition, buyers);
        }
        if (CollectionUtils.isEmpty((Map)positionListMap)) {
            throw new AdxException(AdxErrEnum.POSITION_NOT_FOUND);
        }
        ArrayList requests = Lists.newArrayListWithCapacity((int)this.properties.getMaxCapacityOfBuyers());
        for (Map.Entry positionListEntry : positionListMap.entrySet()) {
            Position position = (Position)positionListEntry.getKey();
            List list = (List)positionListEntry.getValue();
            int level = list.size();
            if (level == 0) continue;
            for (int i = 0; i < level; ++i) {
                MarketRequest marketRequest;
                List array = (List)list.get(i);
                if (CollectionUtils.isEmpty((Collection)array)) continue;
                MarketRequest marketRequest2 = CollectionUtils.isEmpty((Collection)requests) ? null : (marketRequest = requests.size() > i ? (MarketRequest)requests.get(i) : null);
                if (null == marketRequest) {
                    marketRequest = new MarketRequest(i);
                    requests.add(i, marketRequest);
                }
                marketRequest.addBuyers(array);
                marketRequest.addPosition(position);
            }
        }
        MarketOrders marketOrders = new MarketOrders(bidRequest, requests, positionList, uid);
        if (log.isDebugEnabled()) {
            log.debug("{}", (Object)JsonHelper.convert((Object)marketOrders));
        }
        return marketOrders;
    }

    private String getUid(BidRequest bidRequest) {
        Device device = bidRequest.getDevice();
        if (device == null) {
            return null;
        }
        DeviceInfo info = new DeviceInfo().setImei(device.getImei()).setImeiMd5(device.getImei_md5()).setOaid(device.getOaid()).setOaidMd5(device.getOaid_md5()).setAnid(device.getDpid()).setAnidMd5(device.getDpid_md5()).setIdfa(device.getIdfa()).setIdfaMd5(device.getIdfa_md5()).setGaid(device.getGaid()).setGaidMd5(device.getGaid_md5()).setOs(device.isAndroid() ? 1 : (device.isIos() ? 2 : 0));
        String uid = DeviceHelper.getUid((DeviceInfo)info);
        if (StringUtils.isEmpty((Object)AdxContextFactory.get().getUid())) {
            AdxContextFactory.get().setUid(uid);
        }
        return uid;
    }
}

