/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.sell.builder;

import com.bxm.adx.common.sell.builder.BuildAttribute;
import com.bxm.adx.common.sell.builder.BuildAttributeStringMacros;
import com.bxm.adx.common.sell.builder.macros.StringMacrosHandler;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Configuration;

@Configuration
public class BuildAttributeStringMacrosHandler
implements StringMacrosHandler<BuildAttribute>,
ApplicationContextAware {
    private final List<BuildAttributeStringMacros> macros = Lists.newArrayList();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Map beans = applicationContext.getBeansOfType(BuildAttributeStringMacros.class);
        this.macros.addAll(beans.values());
    }

    @Override
    public String replaceAll(String string, BuildAttribute attribute) {
        return this.replaceAll(string, attribute, new String[0]);
    }

    @Override
    public String replaceAll(String string, BuildAttribute attribute, String ... excludes) {
        if (Objects.isNull(attribute)) {
            return string;
        }
        if (StringUtils.isBlank((String)string)) {
            return string;
        }
        HashSet ex = new HashSet();
        if (ArrayUtils.isNotEmpty((Object[])excludes)) {
            ex = Sets.newHashSet((Object[])excludes);
        }
        for (BuildAttributeStringMacros macro : this.macros) {
            String replacement;
            String macroString = macro.getMacroString();
            if (ex.contains(macroString)) continue;
            try {
                replacement = (String)macro.apply(attribute);
            }
            catch (Exception e) {
                replacement = macro.getIfBlankValue();
            }
            if (Objects.isNull(replacement)) {
                replacement = macro.getIfBlankValue();
            }
            string = string.replaceAll(macroString, replacement);
        }
        return string;
    }
}

