/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.sell.rebuild;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;

public abstract class AbstractChainHandler<K>
implements ApplicationListener<ApplicationReadyEvent> {
    private final List<K> handlers = Lists.newArrayList();

    protected abstract Class<K> getInstanceClazz();

    public void onApplicationEvent(ApplicationReadyEvent event) {
        ConfigurableApplicationContext applicationContext = event.getApplicationContext();
        Collection values = applicationContext.getBeansOfType(this.getInstanceClazz()).values();
        values.remove(this);
        if (CollectionUtils.isNotEmpty(values) && this.getInstanceClazz().isAssignableFrom(Ordered.class)) {
            values = values.stream().sorted(Comparator.comparingInt(o -> ((Ordered)o).getOrder())).collect(Collectors.toList());
        }
        this.handlers.addAll(values);
    }

    public List<K> getAll() {
        return this.handlers;
    }
}

