/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.caching;

import com.bxm.warcar.datasync.client.cache.MutableCache;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource
public abstract class AbstractLoadingCache<T>
implements MutableCache {
    private static final Logger log = LoggerFactory.getLogger(AbstractLoadingCache.class);
    protected final ConcurrentHashMap<String, T> caching = new ConcurrentHashMap();

    protected abstract void afterUpdate(T var1, T var2);

    protected abstract void afterDelete(T var1);

    public T set(String key, Object value) throws NullPointerException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)key), (Object)"key");
        Preconditions.checkNotNull((Object)value, (Object)"value");
        T old = this.get(key);
        try {
            Object v = value;
            this.caching.put(key, v);
            this.afterUpdate(old, v);
        }
        catch (Exception e) {
            log.error("set: ", (Throwable)e);
        }
        return old;
    }

    public void del(String key) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)key), (Object)"key");
        try {
            this.afterDelete(this.get(key));
            this.caching.remove(key);
        }
        catch (Exception e) {
            log.error("del: ", (Throwable)e);
        }
    }

    @ManagedOperation
    public T get(String key) throws NullPointerException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)key), (Object)"key");
        try {
            return this.caching.get(key);
        }
        catch (Exception e) {
            log.error("get: ", (Throwable)e);
            return null;
        }
    }

    public long size() {
        return this.caching.size();
    }

    public Map<String, Object> getAll() {
        return Collections.unmodifiableMap(this.caching);
    }

    public Map<String, T> duplicateHashMap() {
        return new HashMap<String, T>(this.caching);
    }
}

