/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.domain;

import com.bxm.adx.common.domain.DomainService;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.warcar.integration.pair.Pair;
import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.util.UriComponentsBuilder;

@Configuration
public class DefaultDomainServiceImpl
implements DomainService {
    private final Pair pair;

    public DefaultDomainServiceImpl(Pair pair) {
        this.pair = pair;
    }

    @Override
    public String replaceCountDomain(BidRequest bidRequest, String baseUrl) {
        return this.getUrl(bidRequest, baseUrl, DomainMapping::getCount);
    }

    @Override
    public String replaceMediaDomain(BidRequest bidRequest, String baseUrl) {
        return this.getUrl(bidRequest, baseUrl, DomainMapping::getMedia);
    }

    @Override
    public String replaceActivityDomain(BidRequest bidRequest, String baseUrl) {
        return this.getUrl(bidRequest, baseUrl, DomainMapping::getActivity);
    }

    private String getUrl(BidRequest bidRequest, String url, Function<DomainMapping, String> function) {
        String serverName = bidRequest.getServerName();
        DomainMapping mapping = (DomainMapping)this.pair.get(serverName).toObject(DomainMapping.class);
        if (Objects.isNull(mapping)) {
            return url;
        }
        String host = function.apply(mapping);
        if (StringUtils.isBlank((String)host)) {
            return url;
        }
        return UriComponentsBuilder.fromUriString((String)url).scheme(mapping.getProtocol()).host(host).build().toUriString();
    }

    private static class DomainMapping {
        private String protocol;
        private String count;
        private String media;
        private String activity;

        public String getProtocol() {
            return this.protocol;
        }

        public String getCount() {
            return this.count;
        }

        public String getMedia() {
            return this.media;
        }

        public String getActivity() {
            return this.activity;
        }

        public void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public void setCount(String count) {
            this.count = count;
        }

        public void setMedia(String media) {
            this.media = media;
        }

        public void setActivity(String activity) {
            this.activity = activity;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DomainMapping)) {
                return false;
            }
            DomainMapping other = (DomainMapping)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$protocol = this.getProtocol();
            String other$protocol = other.getProtocol();
            if (this$protocol == null ? other$protocol != null : !this$protocol.equals(other$protocol)) {
                return false;
            }
            String this$count = this.getCount();
            String other$count = other.getCount();
            if (this$count == null ? other$count != null : !this$count.equals(other$count)) {
                return false;
            }
            String this$media = this.getMedia();
            String other$media = other.getMedia();
            if (this$media == null ? other$media != null : !this$media.equals(other$media)) {
                return false;
            }
            String this$activity = this.getActivity();
            String other$activity = other.getActivity();
            return !(this$activity == null ? other$activity != null : !this$activity.equals(other$activity));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DomainMapping;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $protocol = this.getProtocol();
            result = result * 59 + ($protocol == null ? 43 : $protocol.hashCode());
            String $count = this.getCount();
            result = result * 59 + ($count == null ? 43 : $count.hashCode());
            String $media = this.getMedia();
            result = result * 59 + ($media == null ? 43 : $media.hashCode());
            String $activity = this.getActivity();
            result = result * 59 + ($activity == null ? 43 : $activity.hashCode());
            return result;
        }

        public String toString() {
            return "DefaultDomainServiceImpl.DomainMapping(protocol=" + this.getProtocol() + ", count=" + this.getCount() + ", media=" + this.getMedia() + ", activity=" + this.getActivity() + ")";
        }
    }
}

