/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.filter;

import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.DotEventControlProperties;
import com.bxm.adx.common.buy.buyers.BuyerWrapper;
import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.filter.AbstractDspFilter;
import com.bxm.adx.common.market.MarketOrders;
import com.bxm.adx.common.market.MarketRequest;
import com.bxm.adx.facade.constant.redis.AdxKeyGenerator;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DspAvgExposureLimiterFilter
extends AbstractDspFilter {
    private static final Logger log = LoggerFactory.getLogger(DspAvgExposureLimiterFilter.class);
    private final AdxProperties adxProperties;
    private final Fetcher fetcher;

    public DspAvgExposureLimiterFilter(AdxProperties adxProperties, Fetcher fetcher) {
        this.adxProperties = adxProperties;
        this.fetcher = fetcher;
    }

    @Override
    protected List<Dispatcher> doFilter(MarketOrders marketOrders) {
        List<MarketRequest> requests = marketOrders.getRequests();
        if (CollectionUtils.isEmpty(requests)) {
            return null;
        }
        LocalDateTime now = LocalDateTime.now();
        ArrayList list = Lists.newArrayList();
        requests.forEach(position -> {
            Set<BuyerWrapper> buyerWrappers = position.getBuyers();
            if (CollectionUtils.isEmpty(buyerWrappers)) {
                return;
            }
            buyerWrappers.forEach(buyerWrapper -> {
                Dispatcher dispatcher = buyerWrapper.getDispatcher();
                DotEventControlProperties control = this.needControl(dispatcher.getDspId().toString(), dispatcher.getDspPosid(), now);
                if (Objects.isNull(control)) {
                    return;
                }
                int count = this.getDspPositionExposureBySection(control, now);
                int allCount = this.getDspPositionExposureByControl(control);
                long limit = control.getIntervalLimit(allCount);
                if (count == 0) {
                    return;
                }
                if ((long)count >= limit) {
                    list.add(dispatcher);
                }
            });
        });
        return list;
    }

    private int getDspPositionExposureBySection(DotEventControlProperties control, LocalDateTime now) {
        String dspId = control.getDspId();
        String dspTagId = control.getDspPositionId();
        KeyGenerator keyGenerator = AdxKeyGenerator.Counter.getDspPositionExposureBySection((String)control.getId(), (String)control.getSectionId(now), (String)dspId, (String)dspTagId);
        Long exposure = (Long)this.fetcher.fetch(keyGenerator, Long.class);
        return Objects.isNull(exposure) ? 0 : exposure.intValue();
    }

    private int getDspPositionExposureByControl(DotEventControlProperties control) {
        String dspId = control.getDspId();
        String dspTagId = control.getDspPositionId();
        KeyGenerator keyGenerator = AdxKeyGenerator.Counter.getDspPositionExposureByControl((String)control.getId(), (String)dspId, (String)dspTagId);
        Long exposure = (Long)this.fetcher.fetch(keyGenerator, Long.class);
        return Objects.isNull(exposure) ? 0 : exposure.intValue();
    }

    private DotEventControlProperties needControl(String dspId, String dspTagId, LocalDateTime now) {
        List<DotEventControlProperties> properties = this.adxProperties.getDotEventControls();
        if (CollectionUtils.isEmpty(properties)) {
            return null;
        }
        Optional<DotEventControlProperties> optional = properties.stream().filter((? super T p) -> Objects.nonNull(p.getMt()) && 5 == p.getMt()).filter((? super T p) -> p.getDspId().equals(dspId)).filter((? super T p) -> p.getDspPositionId().equals(dspTagId)).filter((? super T p) -> now.isAfter(p.getStart()) && now.isBefore(p.getEnd())).findFirst();
        return optional.isPresent() ? optional.get() : null;
    }

    @Override
    public int order() {
        return 5;
    }
}

