/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.log.dsplog;

import com.bxm.adx.common.AdxConstants;
import com.bxm.adx.common.adapter.BidModelAdapter;
import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.log.AdxDataLog;
import com.bxm.adx.common.log.AdxDataLogMonitor;
import com.bxm.adx.common.log.buriedSwitch.BuriedSwitchDao;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.response.SeatBid;
import com.bxm.warcar.integration.distributed.DisableDistributed;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.NamedThreadFactory;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class DspLogRecord
implements DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(DspLogRecord.class);
    private final ObjectMapper mapper = new ObjectMapper();
    private final Logger requestLogger = LoggerFactory.getLogger((String)(DspLogRecord.class.getName() + ".request"));
    private final Logger responseLogger = LoggerFactory.getLogger((String)(DspLogRecord.class.getName() + ".response"));
    private final Logger dspOriginalResponseLogger = LoggerFactory.getLogger((String)(DspLogRecord.class.getName() + ".originalResponse"));
    private final Logger bxmOriginalResponseLogger = LoggerFactory.getLogger((String)(DspLogRecord.class.getName() + ".bxmOriginalResponse"));
    private final Logger bxmResponseLogger = LoggerFactory.getLogger((String)(DspLogRecord.class.getName() + ".bxmResponse"));
    private final Logger mediaResponseLogger = LoggerFactory.getLogger((String)(DspLogRecord.class.getName() + ".mediaResponse"));
    private final ThreadPoolExecutor executor = new ThreadPoolExecutor(10, 20, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1000), (ThreadFactory)new NamedThreadFactory("dspLogResponse"), new ThreadPoolExecutor.CallerRunsPolicy());
    private final ThreadPoolExecutor buriedExecutor = new ThreadPoolExecutor(10, 20, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1000), (ThreadFactory)new NamedThreadFactory("dspBuriedResponse"), new ThreadPoolExecutor.DiscardPolicy());
    private final ConcurrentHashMap<String, Long> map = new ConcurrentHashMap();
    private final BuriedSwitchDao buriedSwitchDao;
    private final AdxDataLogMonitor adxDataLogMonitor;

    public DspLogRecord(BuriedSwitchDao buriedSwitchDao, AdxDataLogMonitor adxDataLogMonitor) {
        this.buriedSwitchDao = buriedSwitchDao;
        this.adxDataLogMonitor = adxDataLogMonitor;
    }

    @PostConstruct
    public void init() {
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    public void responseLog(BidResponse bidResponse, byte[] mediaResponse, BidModelAdapter adapter) {
        if (bidResponse == null || CollectionUtils.isEmpty(bidResponse.getSeat_bid())) {
            return;
        }
        for (SeatBid sb : bidResponse.getSeat_bid()) {
            if (!this.buriedSwitchDao.getBuriedSwitch(sb.getPositionId(), sb.getDspId(), sb.getDspPosid()).booleanValue()) continue;
            AdxDataLog mediaResponseLog = new AdxDataLog(bidResponse.getId(), sb.getPositionId(), sb.getDspId(), sb.getDspPosid(), sb.getDspAppid(), adapter.getRequestFormat(), null, adapter.convertSspResponse(mediaResponse), null);
            AdxDataLog bxmResponseLog = new AdxDataLog(bidResponse.getId(), sb.getPositionId(), sb.getDspId(), sb.getDspPosid(), sb.getDspAppid(), AdxConstants.Format.Json, null, JsonHelper.convert((Object)bidResponse), null);
            try {
                this.log(this.mapper.writeValueAsString((Object)bxmResponseLog), this.bxmResponseLogger);
                this.log(this.mapper.writeValueAsString((Object)mediaResponseLog), this.mediaResponseLogger);
                this.adxDataLogMonitor.responseMonitor(sb.getPositionId(), sb.getDspId(), sb.getDspPosid());
            }
            catch (Exception e) {
                log.error("Jackson JSON \u89e3\u6790\u9519\u8bef", (Throwable)e);
            }
        }
    }

    public void dspLog(BidRequest request, String str, AdxConstants.Format format, BidResponse response, Dispatcher dispatcher) {
        try {
            this.logRequest(request);
            if (this.buriedSwitchDao.getBuriedSwitch(dispatcher.getPositionId(), dispatcher.getDspId(), dispatcher.getDspPosid()).booleanValue()) {
                this.logDspOriginalResponse(new AdxDataLog(request.getId(), dispatcher.getPositionId(), dispatcher.getDspId(), dispatcher.getDspPosid(), dispatcher.getDspAppid(), format, null, str, null), this.dspOriginalResponseLogger);
                this.logDspOriginalResponse(new AdxDataLog(request.getId(), dispatcher.getPositionId(), dispatcher.getDspId(), dispatcher.getDspPosid(), dispatcher.getDspAppid(), AdxConstants.Format.Json, null, JsonHelper.convert((Object)response), null), this.bxmOriginalResponseLogger);
                this.adxDataLogMonitor.originalResponseMonitor(dispatcher.getPositionId(), dispatcher.getDspId(), dispatcher.getDspPosid());
            }
            if (StringUtils.isEmpty((String)response.getId())) {
                response.setId(request.getId());
            }
            for (SeatBid seatBid : response.getSeat_bid()) {
                seatBid.setDspId(dispatcher.getDspId());
            }
            this.logResponse(response);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void logDspOriginalResponse(AdxDataLog dataLog, Logger logger) {
        if (dataLog == null) {
            return;
        }
        try {
            this.log(this.mapper.writeValueAsString((Object)dataLog), logger);
        }
        catch (Exception e) {
            log.error("logOriginalResponse error", (Throwable)e);
        }
    }

    private void log(String s, Logger logger) {
        if (StringUtils.isNotBlank((String)s)) {
            this.buriedExecutor.execute(() -> logger.info(s));
        }
    }

    private void logResponse(BidResponse obj) {
        if (obj == null) {
            return;
        }
        try {
            String s = this.mapper.writeValueAsString((Object)obj);
            this.executor.execute(() -> this.responseLogger.info(s));
        }
        catch (Exception e) {
            log.error("jackson json error", (Throwable)e);
        }
    }

    private void logRequest(BidRequest obj) {
        if (obj == null) {
            return;
        }
        if (this.map.containsKey(obj.getId())) {
            return;
        }
        this.map.put(obj.getId(), System.currentTimeMillis());
        try {
            String s = this.mapper.writeValueAsString((Object)obj);
            this.executor.execute(() -> this.requestLogger.info(s));
        }
        catch (Exception e) {
            log.error("jackson json error", (Throwable)e);
        }
    }

    @DisableDistributed
    @Scheduled(cron="*/1 * * * * ?")
    public void deleteExpireKey() {
        long l = System.currentTimeMillis();
        for (Map.Entry<String, Long> entry : this.map.entrySet()) {
            if (l - entry.getValue() <= 1000L) continue;
            this.map.remove(entry.getKey());
        }
    }

    public void destroy() {
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

