/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.exchange.rebuild.request;

import com.bxm.adx.common.market.exchange.rebuild.request.AdxBidRequestBuilder;
import com.bxm.adx.common.market.exchange.rebuild.request.RequestBuildAttribute;
import com.bxm.adx.common.sell.BidRequest;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AdxBidRequestBuildFactory
implements ApplicationListener<ApplicationReadyEvent> {
    private List<AdxBidRequestBuilder> builderList = new ArrayList<AdxBidRequestBuilder>();

    public void onApplicationEvent(ApplicationReadyEvent event) {
        this.builderList.addAll(event.getApplicationContext().getBeansOfType(AdxBidRequestBuilder.class).values());
    }

    public BidRequest buildAdxBidRequest(BidRequest bidRequest, RequestBuildAttribute attribute) {
        BidRequest init = this.initAdxBidRequest(bidRequest);
        this.builderList.forEach(builder -> builder.rebuildAdxBidRequest(init, attribute));
        return init;
    }

    private BidRequest initAdxBidRequest(BidRequest bidRequest) {
        BidRequest adxBidRequest = new BidRequest();
        BeanUtils.copyProperties((Object)bidRequest, (Object)adxBidRequest);
        return adxBidRequest;
    }
}

