/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.exchange.rebuild.response;

import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.market.exchange.rebuild.offer.OfferFactory;
import com.bxm.adx.common.market.exchange.rebuild.offer.OfferResult;
import com.bxm.adx.common.market.exchange.rebuild.response.AdxBidResponseBuilder;
import com.bxm.adx.common.market.exchange.rebuild.response.ResponseBuildAttribute;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.SeatBid;
import com.bxm.adx.facade.constant.enums.AdxErrEnum;
import com.bxm.adx.facade.exception.AdxException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class OfferPriceBuilder
implements AdxBidResponseBuilder {
    private static final Logger log = LoggerFactory.getLogger(OfferPriceBuilder.class);
    private final OfferFactory factory;

    public OfferPriceBuilder(OfferFactory factory) {
        this.factory = factory;
    }

    public int getOrder() {
        return 5;
    }

    @Override
    public void rebuildAdxBidResponse(BidResponse bidResponse, ResponseBuildAttribute attribute) {
        Dispatcher dispatcher = attribute.getDispatcher();
        BidRequest request = attribute.getBidRequest();
        for (SeatBid seatBid : bidResponse.getSeat_bid()) {
            Map<Bid, OfferResult> offerResultMap = this.factory.offer(seatBid.getBid(), request, dispatcher);
            block5: for (Bid bid : seatBid.getBid()) {
                OfferResult result = offerResultMap.get(bid);
                int chargeType = result.getChargeType();
                bid.setCharge_type(chargeType);
                int budgetType = result.getBudgetType();
                bid.setBudget_type(budgetType);
                switch (budgetType) {
                    case 1: {
                        bid.setPrice(result.getOffer());
                        bid.setBid(null);
                        continue block5;
                    }
                    case 2: {
                        bid.setBid(result.getOffer());
                        bid.setPrice(null);
                        continue block5;
                    }
                }
                log.warn("unsupported budgetType, dispatcher {}", (Object)dispatcher.getId());
                throw new AdxException(AdxErrEnum.DISPATCHER_ERR);
            }
        }
    }
}

