/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.filter;

import com.bxm.adx.common.market.Deal;
import com.bxm.adx.common.market.filter.DealFilterCondition;
import com.bxm.adx.common.market.filter.Filter;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.SeatBid;
import com.bxm.adx.common.utils.MapHelper;
import com.bxm.warcar.utils.JsonHelper;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;

@Configuration
@DealFilterCondition(chargeType=1)
public class PriceLowerFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(PriceLowerFilter.class);

    @Override
    public void filter(List<Deal> deals, Set<Deal> trash) {
        Optional<Bid> topPriceBid = this.getTopPriceBid(deals);
        if (!topPriceBid.isPresent()) {
            if (log.isDebugEnabled()) {
                log.debug("No valid price");
            }
            deals.removeIf(deal -> true);
            return;
        }
        BigDecimal topPrice = topPriceBid.get().getPrice();
        HashMap higher = Maps.newHashMap();
        String key = "higher";
        Set remove = deals.stream().filter(deal -> {
            BidResponse response = deal.getBidResponse();
            List<SeatBid> seatBids = response.getSeat_bid();
            seatBids.removeIf(seatBid -> {
                List<Bid> bidList = seatBid.getBid();
                bidList.removeIf(b -> {
                    BigDecimal price = b.getPrice();
                    if (price.compareTo(topPrice) < 0) {
                        return true;
                    }
                    if (price.compareTo(topPrice) == 0) {
                        if (CollectionUtils.isEmpty((Map)higher)) {
                            MapHelper.get(higher, key, price);
                            return false;
                        }
                        return true;
                    }
                    log.warn("warning bid top price wrong, top price = {},  deal = {}", (Object)topPrice.toString(), (Object)JsonHelper.convert((Object)deal));
                    MapHelper.get(higher, key, price);
                    return false;
                });
                return org.apache.commons.collections.CollectionUtils.isEmpty(bidList);
            });
            return org.apache.commons.collections.CollectionUtils.isEmpty(seatBids);
        }).collect(Collectors.toSet());
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(remove)) {
            trash.addAll(remove);
        }
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    private Optional<Bid> getTopPriceBid(List<Deal> deals) {
        return deals.stream().filter(deal -> Objects.nonNull(deal.getBidResponse())).map(Deal::getBidResponse).filter(bidResponse -> org.apache.commons.collections.CollectionUtils.isNotEmpty(bidResponse.getSeat_bid())).map(BidResponse::getSeat_bid).flatMap(Collection::stream).filter(seatBid -> org.apache.commons.collections.CollectionUtils.isNotEmpty(seatBid.getBid())).map(SeatBid::getBid).flatMap(Collection::stream).filter(bid -> Objects.nonNull(bid.getPrice())).sorted(Comparator.comparing(Bid::getPrice).reversed()).findFirst();
    }
}

