/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.filter;

import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.market.Deal;
import com.bxm.adx.common.market.filter.Filter;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class PriorityFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(PriorityFilter.class);

    @Override
    public void filter(List<Deal> deals, Set<Deal> trash) {
        Set priorities = deals.stream().filter(deal -> Objects.nonNull(deal.getDispatcher())).map(Deal::getDispatcher).filter(dispatcher -> Objects.nonNull(dispatcher.getReturnPriority())).map(Dispatcher::getReturnPriority).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(priorities)) {
            return;
        }
        Integer priority = (Integer)priorities.stream().sorted().findFirst().get();
        Set remove = deals.stream().filter(deal -> {
            Dispatcher dispatcher = deal.getDispatcher();
            if (Objects.isNull(dispatcher)) {
                return true;
            }
            if (Objects.isNull(dispatcher.getReturnPriority())) {
                return true;
            }
            return dispatcher.getReturnPriority() > priority;
        }).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(remove)) {
            trash.addAll(remove);
        }
    }

    public int getOrder() {
        return 0;
    }
}

