/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.monitor;

import com.bxm.adx.common.AdxConstants;
import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.CacheKeys;
import com.bxm.adx.common.Imp302Properties;
import com.bxm.adx.common.OpenLogProperties;
import com.bxm.adx.common.OpenlogConstants;
import com.bxm.adx.common.market.monitor.MonitorHandler;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.builder.BuildAttribute;
import com.bxm.adx.common.sell.builder.BuildAttributeStringMacrosHandler;
import com.bxm.adx.common.sell.response.AppMonitor;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.ClickMonitor;
import com.bxm.adx.common.sell.response.DpMonitor;
import com.bxm.adx.common.sell.response.ImpMonitor;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.utils.UrlHelper;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.util.UriComponentsBuilder;

@Component
public class AdxMonitorHandler
implements MonitorHandler {
    private final String DSP_IMP = "u1";
    private final int[] DP_MT = new int[]{10, 11, 12};
    private final int[] DOWNLOAD_MT = new int[]{16, 15, 18, 17};
    private final AdxProperties adxProperties;
    private final BuildAttributeStringMacrosHandler macrosHandler;
    private final Updater updater;

    public AdxMonitorHandler(AdxProperties adxProperties, BuildAttributeStringMacrosHandler macrosHandler, Updater updater) {
        this.adxProperties = adxProperties;
        this.macrosHandler = macrosHandler;
        this.updater = updater;
    }

    @Override
    public void handler(BuildAttribute attribute) {
        Bid bid = attribute.getBid();
        OpenLogProperties properties = this.adxProperties.getOpenLog();
        bid.setImp_monitors(this.impMonitors(bid, attribute, properties));
        bid.setClick_monitors(this.clickMonitors(bid, attribute, properties));
        if (this.isDp(bid)) {
            bid.setDpMonitor(this.dpMonitor(bid, attribute, properties));
        }
        if (this.isDownload(bid)) {
            bid.setApp_monitor(this.appMonitor(bid, attribute, properties));
        }
        if (this.needFailUrlByMedia(attribute.getMediaId())) {
            String failUrl = this.adxProperties.getOpenLog().createNeed(false, 999, OpenlogConstants.WITH_MACROS);
            bid.setFail_url(this.macrosHandler.replaceAll(failUrl, attribute.setMt(999)));
        }
    }

    public int getOrder() {
        return 1;
    }

    private List<ImpMonitor> impMonitors(Bid bid, BuildAttribute attribute, OpenLogProperties properties) {
        String impUrl = this.getImpUrl(bid, attribute, properties);
        List<ImpMonitor> impMonitors = bid.getImp_monitors();
        if (this.imp302(attribute) && !CollectionUtils.isEmpty(impMonitors) && impMonitors.size() > 0) {
            String dspUrl = impMonitors.get(0).getImp_monitor_url();
            impMonitors.remove(0);
            String impUrl302 = this.getImpUrl302(impUrl, dspUrl, attribute);
            impMonitors.add(ImpMonitor.builder().imp_monitor_url(impUrl302).build());
            return impMonitors;
        }
        impMonitors.add(ImpMonitor.builder().imp_monitor_url(impUrl).build());
        return impMonitors;
    }

    private String getImpUrl(Bid bid, BuildAttribute attribute, OpenLogProperties properties) {
        int mt = 5;
        String impUrl = this.getUrl(properties, mt, "down_x", "down_y", "up_x", "up_y", "ad_width", "ad_height");
        impUrl = this.macrosHandler.replaceAll(impUrl, attribute.setMt(mt));
        impUrl = this.replaceMacroPrice(impUrl, bid, attribute.getSspRequest());
        return impUrl;
    }

    private String getImpUrl302(String bxmImpUrl, String dspImpUrl, BuildAttribute attribute) {
        String url = this.adxProperties.getAdsCounter().getAdx302Url(false, true);
        String replacedUrl = this.macrosHandler.replaceAll(url, attribute);
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)replacedUrl);
        builder.replaceQueryParam("u1", new Object[]{UrlHelper.urlEncode((String)dspImpUrl)});
        this.saveImpUrl(attribute, bxmImpUrl);
        return builder.build().toString();
    }

    private void saveImpUrl(BuildAttribute attribute, String url) {
        KeyGenerator key = CacheKeys.getImpUrl302(attribute.getSspRequest().getId(), attribute.getMediaId(), attribute.getTagId(), attribute.getDspId().toString(), attribute.getdTagId());
        this.updater.updateWithSelector(key, (Object)url, 86400, 4);
    }

    private boolean imp302(BuildAttribute attribute) {
        String mediaId = attribute.getMediaId();
        String dspId = attribute.getDspId().toString();
        String appId = attribute.getAppId();
        Imp302Properties properties = this.adxProperties.getImp302();
        for (Imp302Properties.MediaConfig config : properties.getMediaConfigs()) {
            if (!mediaId.equals(config.getMediaId())) continue;
            List<String> appIds = config.getAppIds();
            List<String> dspIds = config.getDspIds();
            if (!CollectionUtils.isEmpty(appIds) && !appIds.contains(appId) || CollectionUtils.isEmpty(dspIds) || !dspIds.contains(dspId)) continue;
            return true;
        }
        return false;
    }

    private List<ClickMonitor> clickMonitors(Bid bid, BuildAttribute attribute, OpenLogProperties properties) {
        int mt = 6;
        List<ClickMonitor> clickMonitors = Optional.ofNullable(bid.getClick_monitors()).orElse(Lists.newArrayList());
        String clickUrl = this.getUrl(properties, mt, new String[0]);
        clickMonitors.add(ClickMonitor.builder().click_monitor_url(this.macrosHandler.replaceAll(clickUrl, attribute.setMt(mt))).build());
        return clickMonitors;
    }

    private DpMonitor dpMonitor(Bid bid, BuildAttribute attribute, OpenLogProperties properties) {
        DpMonitor dpMonitor = Optional.ofNullable(bid.getDpMonitor()).orElse(DpMonitor.builder().build());
        attribute.setMt(null);
        block5: for (int mt : this.DP_MT) {
            String url = this.getUrl(properties, mt, OpenlogConstants.WITHOUT_MACROS_OUT);
            url = this.macrosHandler.replaceAll(url, attribute);
            switch (mt) {
                case 10: {
                    dpMonitor.setAwk_start_urls(this.mergeUrl(dpMonitor.getAwk_start_urls(), url));
                    continue block5;
                }
                case 11: {
                    dpMonitor.setAwk_success_urls(this.mergeUrl(dpMonitor.getAwk_success_urls(), url));
                    continue block5;
                }
                case 12: {
                    dpMonitor.setAwk_fail_urls(this.mergeUrl(dpMonitor.getAwk_fail_urls(), url));
                }
            }
        }
        return dpMonitor;
    }

    private AppMonitor appMonitor(Bid bid, BuildAttribute attribute, OpenLogProperties properties) {
        AppMonitor appMonitor = Optional.ofNullable(bid.getApp_monitor()).orElse(AppMonitor.builder().build());
        attribute.setMt(null);
        block6: for (int mt : this.DOWNLOAD_MT) {
            String url = this.adxProperties.getOpenLog().create(mt, OpenlogConstants.WITHOUT_MACROS_OUT);
            this.macrosHandler.replaceAll(url, attribute);
            switch (mt) {
                case 15: {
                    appMonitor.setDs_urls(this.mergeUrl(appMonitor.getDs_urls(), url));
                    continue block6;
                }
                case 16: {
                    appMonitor.setDf_urls(this.mergeUrl(appMonitor.getDf_urls(), url));
                    continue block6;
                }
                case 17: {
                    appMonitor.setSs_urls(this.mergeUrl(appMonitor.getSs_urls(), url));
                    continue block6;
                }
                case 18: {
                    appMonitor.setSf_urls(this.mergeUrl(appMonitor.getSf_urls(), url));
                }
            }
        }
        return appMonitor;
    }

    private String getUrl(OpenLogProperties properties, int mt, String ... removeParams) {
        return properties.create(mt, removeParams);
    }

    private String replaceMacroPrice(String url, Bid bid, BidRequest request) {
        if (AdxConstants.needReplacePrice(request.getMediaId())) {
            String price = "0";
            if (Objects.nonNull(bid.getPrice())) {
                price = bid.getPrice().toString();
            }
            url = url.replace("__PRICE__", price);
        }
        return url;
    }

    private boolean isDp(Bid bid) {
        return StringUtils.isNotEmpty((String)bid.getDeep_link_url()) ? true : StringUtils.isNotEmpty((String)bid.getUniversal_link());
    }

    private boolean isDownload(Bid bid) {
        if (Objects.nonNull(bid.getDownload_info())) {
            return true;
        }
        return StringUtils.isNotEmpty((String)bid.getApp_download_url());
    }

    private List<String> mergeUrl(List<String> list, String url) {
        list = Optional.ofNullable(list).orElse(Lists.newArrayList());
        list.add(url);
        return list;
    }

    private boolean needFailUrlByMedia(String mediaId) {
        AdxConstants.Media media;
        return StringUtils.isNotEmpty((String)mediaId) && (AdxConstants.Media.Oppo == (media = AdxConstants.Media.of(Integer.parseInt(mediaId))) || AdxConstants.Media.Sigmob == media);
    }
}

