/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.nbr;

import com.bxm.adx.common.market.exchange.ExchangeResult;
import com.bxm.adx.common.market.exchange.PriorityExchanger;
import com.bxm.adx.common.market.nbr.NoBidResponseService;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;

@Aspect
public class NoBidResponseAspect {
    private NoBidResponseService noBidResponseService;

    public NoBidResponseAspect(NoBidResponseService noBidResponseService) {
        this.noBidResponseService = noBidResponseService;
    }

    @Pointcut(value="this(com.bxm.adx.common.market.exchange.PriorityExchanger) && execution(* exchange(..))")
    public void pointcut() {
    }

    @AfterReturning(pointcut="pointcut()", returning="returnVal")
    public void afterReturning(JoinPoint point, Object returnVal) throws Throwable {
        Object target = point.getTarget();
        if (!(target instanceof PriorityExchanger)) {
            return;
        }
        if (!(returnVal instanceof ExchangeResult)) {
            return;
        }
        ExchangeResult result = (ExchangeResult)returnVal;
        this.noBidResponseService.handler(result);
    }
}

