/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.openlog.listener.external;

import com.bxm.adx.common.openlog.event.external.AdShowEvent;
import com.bxm.adx.facade.constant.redis.AdxKeyGenerator;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AdShowForDspMaxExposureLimiterEventListener
implements EventListener<AdShowEvent> {
    private static final Logger log = LoggerFactory.getLogger(AdShowForDspMaxExposureLimiterEventListener.class);
    private final Counter counter;

    public AdShowForDspMaxExposureLimiterEventListener(Counter counter) {
        this.counter = counter;
    }

    @Subscribe
    @AllowConcurrentEvents
    public void consume(AdShowEvent event) {
        this.handleDspExposureWithConfigId(event);
    }

    private void handleDspExposureWithConfigId(AdShowEvent event) {
        KeyValueMap map = event.getLog();
        String dspId = (String)map.getFirst((Object)"dspid");
        String configId = (String)map.getFirst((Object)"configid");
        String dspTagId = (String)map.getFirst((Object)"dtagid");
        KeyGenerator keyGenerator = AdxKeyGenerator.Counter.getPositionDspExposure((String)configId, (String)dspId, (String)dspTagId);
        LocalDateTime midnight = LocalDateTime.now().plusDays(1L).withHour(0).withMinute(0).withSecond(0).withNano(0);
        long seconds = ChronoUnit.SECONDS.between(LocalDateTime.now(), midnight);
        this.counter.incrementAndGet(keyGenerator, (int)seconds);
    }
}

