/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.openlog.listener.internal;

import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.DotEventControlProperties;
import com.bxm.adx.common.OpenlogConstants;
import com.bxm.adx.common.openlog.event.internal.DspBidEvent;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.builder.BuildAttribute;
import com.bxm.adx.common.sell.builder.BuildAttributeStringMacrosHandler;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.SeatBid;
import com.bxm.adx.facade.constant.redis.AdxKeyGenerator;
import com.bxm.openlog.extension.client.OpenLogClient;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.UrlHelper;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

@Configuration
public class DotDspBidEventListener
implements EventListener<DspBidEvent> {
    private final int EXPIRE_SECONDS_12_HOURS = 43200;
    private final int EXPIRE_SECONDS_24_HOURS = 86400;
    private final Counter counter;
    private OpenLogClient openLogClient;
    private final AdxProperties properties;
    private final BuildAttributeStringMacrosHandler macrosHandler;

    public DotDspBidEventListener(Counter counter, AdxProperties properties, BuildAttributeStringMacrosHandler macrosHandler) {
        this.counter = counter;
        this.properties = properties;
        this.macrosHandler = macrosHandler;
    }

    @Autowired
    public void setOpenLogClient(OpenLogClient openLogClient) {
        this.openLogClient = openLogClient;
    }

    @Subscribe
    @AllowConcurrentEvents
    public void consume(DspBidEvent event) {
        this.handleDspAvgFill(event);
        if (Math.abs(event.getSspRequest().getId().hashCode() % 100) >= this.properties.getDotSimplingPercent()) {
            return;
        }
        MultiValueMap<String, String> customizeParams = this.buildCustomizeParams(event.getDspResponse());
        String url = this.properties.getOpenLog().create(true, 3, customizeParams, OpenlogConstants.WITHOUT_MACROS_INNER);
        BuildAttribute attribute = new BuildAttribute(3).setDspId(event.getDspId()).setSspRequest(event.getSspRequest()).setAdxRequest(event.getAdxRequest()).setDspResponse(event.getDspResponse()).setStrategyId(event.getStrategyId());
        url = this.macrosHandler.replaceAll(url, attribute);
        this.openLogClient.asyncRequest(url);
    }

    private void handleDspAvgFill(DspBidEvent event) {
        LocalDateTime now;
        String dspTagId;
        String dspId = event.getDspId().toString();
        DotEventControlProperties control = this.needControl(dspId, dspTagId = event.getAdxRequest().getImps().iterator().next().getTag_id(), now = LocalDateTime.now());
        if (Objects.isNull(control)) {
            return;
        }
        KeyGenerator sectionKey = AdxKeyGenerator.Counter.getDspPositionFillBySection((String)control.getId(), (String)control.getSectionId(now), (String)dspId, (String)dspTagId);
        KeyGenerator controlKey = AdxKeyGenerator.Counter.getDspPositionFillByControl((String)control.getId(), (String)dspId, (String)dspTagId);
        this.counter.incrementAndGet(sectionKey, 43200);
        this.counter.incrementAndGet(controlKey, 86400);
    }

    private DotEventControlProperties needControl(String dspId, String dspTagId, LocalDateTime now) {
        List<DotEventControlProperties> controls = this.properties.getDotEventControls();
        if (CollectionUtils.isEmpty(controls)) {
            return null;
        }
        Optional<DotEventControlProperties> optional = controls.stream().filter(p -> Objects.nonNull(p.getMt()) && 3 == p.getMt()).filter(p -> p.getDspId().equals(dspId)).filter(p -> p.getDspPositionId().equals(dspTagId)).filter(p -> now.isAfter(p.getStart()) && now.isBefore(p.getEnd())).findFirst();
        return optional.isPresent() ? optional.get() : null;
    }

    private MultiValueMap<String, String> buildCustomizeParams(BidResponse bidResponse) {
        LinkedMultiValueMap customizeParams = new LinkedMultiValueMap();
        List<Creative> creatives = this.getCreatives(bidResponse);
        String value = UrlHelper.urlEncode((String)JsonHelper.convert(creatives));
        customizeParams.add((Object)"creatives", (Object)value);
        return customizeParams;
    }

    private List<Creative> getCreatives(BidResponse bidResponse) {
        ArrayList<Creative> creatives = new ArrayList<Creative>();
        for (SeatBid seatBid : bidResponse.getSeat_bid()) {
            for (Bid bid : seatBid.getBid()) {
                Creative creative = new Creative().setCreativeId(bid.getCreate_id()).setTicketId(bid.getAdid()).setBdgtyp(bid.getDsp_budget_type()).setPrice(bid.getDsp_price().toString()).setTid(bid.getTask_id()).setDpcid(bid.getDpc_id());
                creatives.add(creative);
            }
        }
        return creatives;
    }

    private static class Creative {
        private String creativeId;
        private String ticketId;
        private String price;
        private String tid;
        private String dpcid;
        private Integer bdgtyp;

        public String getCreativeId() {
            return this.creativeId;
        }

        public String getTicketId() {
            return this.ticketId;
        }

        public String getPrice() {
            return this.price;
        }

        public String getTid() {
            return this.tid;
        }

        public String getDpcid() {
            return this.dpcid;
        }

        public Integer getBdgtyp() {
            return this.bdgtyp;
        }

        public Creative setCreativeId(String creativeId) {
            this.creativeId = creativeId;
            return this;
        }

        public Creative setTicketId(String ticketId) {
            this.ticketId = ticketId;
            return this;
        }

        public Creative setPrice(String price) {
            this.price = price;
            return this;
        }

        public Creative setTid(String tid) {
            this.tid = tid;
            return this;
        }

        public Creative setDpcid(String dpcid) {
            this.dpcid = dpcid;
            return this;
        }

        public Creative setBdgtyp(Integer bdgtyp) {
            this.bdgtyp = bdgtyp;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Creative)) {
                return false;
            }
            Creative other = (Creative)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$bdgtyp = this.getBdgtyp();
            Integer other$bdgtyp = other.getBdgtyp();
            if (this$bdgtyp == null ? other$bdgtyp != null : !((Object)this$bdgtyp).equals(other$bdgtyp)) {
                return false;
            }
            String this$creativeId = this.getCreativeId();
            String other$creativeId = other.getCreativeId();
            if (this$creativeId == null ? other$creativeId != null : !this$creativeId.equals(other$creativeId)) {
                return false;
            }
            String this$ticketId = this.getTicketId();
            String other$ticketId = other.getTicketId();
            if (this$ticketId == null ? other$ticketId != null : !this$ticketId.equals(other$ticketId)) {
                return false;
            }
            String this$price = this.getPrice();
            String other$price = other.getPrice();
            if (this$price == null ? other$price != null : !this$price.equals(other$price)) {
                return false;
            }
            String this$tid = this.getTid();
            String other$tid = other.getTid();
            if (this$tid == null ? other$tid != null : !this$tid.equals(other$tid)) {
                return false;
            }
            String this$dpcid = this.getDpcid();
            String other$dpcid = other.getDpcid();
            return !(this$dpcid == null ? other$dpcid != null : !this$dpcid.equals(other$dpcid));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Creative;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $bdgtyp = this.getBdgtyp();
            result = result * 59 + ($bdgtyp == null ? 43 : ((Object)$bdgtyp).hashCode());
            String $creativeId = this.getCreativeId();
            result = result * 59 + ($creativeId == null ? 43 : $creativeId.hashCode());
            String $ticketId = this.getTicketId();
            result = result * 59 + ($ticketId == null ? 43 : $ticketId.hashCode());
            String $price = this.getPrice();
            result = result * 59 + ($price == null ? 43 : $price.hashCode());
            String $tid = this.getTid();
            result = result * 59 + ($tid == null ? 43 : $tid.hashCode());
            String $dpcid = this.getDpcid();
            result = result * 59 + ($dpcid == null ? 43 : $dpcid.hashCode());
            return result;
        }

        public String toString() {
            return "DotDspBidEventListener.Creative(creativeId=" + this.getCreativeId() + ", ticketId=" + this.getTicketId() + ", price=" + this.getPrice() + ", tid=" + this.getTid() + ", dpcid=" + this.getDpcid() + ", bdgtyp=" + this.getBdgtyp() + ")";
        }
    }
}

