/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.risk;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.poi.excel.ExcelReader;
import cn.hutool.poi.excel.ExcelUtil;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.request.Device;
import com.bxm.adx.common.sell.request.User;
import com.bxm.adx.facade.constant.redis.AdxKeyGenerator;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.openxml4j.util.ZipSecureFile;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.Async;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/risk"})
@ConditionalOnProperty(prefix="adx", name={"risk.crowd-hit-open"}, havingValue="true")
public class RiskCrowdHit {
    @Autowired
    private Counter counter;
    @Autowired
    private Fetcher fetcher;
    private Map<String, Set<String>> map = new HashMap<String, Set<String>>();
    private final String ip = "IP";
    private final String device = "DEVICEID";
    private final String uid = "UID";
    private final String token = "riskCrowdHitQuery";
    private final Integer expireTime = 1209600;

    @PostConstruct
    public void init() {
        this.map.put("IP", new HashSet());
        this.map.put("DEVICEID", new HashSet());
        this.map.put("UID", new HashSet());
        ZipSecureFile.setMinInflateRatio((double)-1.0);
        ExcelReader reader = ExcelUtil.getReader((File)FileUtil.file((String)"classpath:risk/ADX\u98ce\u63a7\u5305.xlsx"));
        int sheetCount = reader.getSheetCount();
        reader.close();
        for (int i = 0; i < sheetCount; ++i) {
            this.readSheet(ExcelUtil.getReader((File)FileUtil.file((String)"classpath:risk/ADX\u98ce\u63a7\u5305.xlsx"), (int)i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readSheet(ExcelReader reader) {
        try {
            List crowdData = reader.readAll(RiskCrowdData.class);
            for (RiskCrowdData data : crowdData) {
                Set<String> contents = this.map.get(data.getType());
                if (contents == null || !StringUtils.isNotEmpty((CharSequence)data.getContent())) continue;
                contents.add(data.getContent());
            }
        }
        finally {
            reader.close();
        }
    }

    @GetMapping(value={"/crowd/hit"})
    public List<RiskCrowdHitData> getCrowdHitData(@RequestParam(value="token") String token) {
        if (!this.token.equals(token)) {
            return null;
        }
        ArrayList dataList = Lists.newArrayList();
        DateTime dateTime = DateUtil.offsetDay((Date)DateUtil.date(), (int)-5);
        for (int i = 1; i <= 10; ++i) {
            String tmp = DateUtil.offsetDay((Date)dateTime, (int)i).toString("yyyy-MM-dd");
            Long requestCount = (Long)this.fetcher.fetch(AdxKeyGenerator.Risk.getRiskCrowdRequestCount((String)tmp), Long.class);
            if (requestCount == null) continue;
            Long hitCount = (Long)this.fetcher.fetch(AdxKeyGenerator.Risk.getRiskCrowdHitCount((String)tmp), Long.class);
            Double hitRate = null;
            if (hitCount != null) {
                hitRate = (double)hitCount.longValue() / (double)requestCount.longValue();
            }
            dataList.add(RiskCrowdHitData.builder().date(tmp).requestCount(requestCount).crowdHitCount(hitCount).hitRate(hitRate).build());
        }
        return dataList;
    }

    @Async(value="taskExecutor")
    public void crowdHitDeal(BidRequest request) {
        if (request == null) {
            return;
        }
        String date = DateUtil.today();
        this.redisIncrease(date, true);
        boolean hitIncrease = false;
        User user = request.getUser();
        if (user != null) {
            hitIncrease = this.map.get("UID").contains(user.getId());
        }
        Device device = request.getDevice();
        if (!hitIncrease && device != null && !(hitIncrease = this.map.get("IP").contains(device.getIp()))) {
            ArrayList deviceIdList = Lists.newArrayList((Object[])new String[]{device.getImei(), device.getImei_md5(), device.getIdfa(), device.getIdfa_md5(), device.getMac(), device.getMac_md5(), device.getOaid(), device.getOaid_md5(), device.getDpid(), device.getDpid_md5(), device.getVaid(), device.getGaid(), device.getGaid_md5()});
            for (String tmp : deviceIdList) {
                hitIncrease = this.map.get(this.device).contains(tmp);
                if (!hitIncrease) continue;
                break;
            }
        }
        if (hitIncrease) {
            this.redisIncrease(date, false);
        }
    }

    private void redisIncrease(String date, boolean isRequest) {
        if (isRequest) {
            KeyGenerator requestCount = AdxKeyGenerator.Risk.getRiskCrowdRequestCount((String)date);
            this.counter.incrementAndGet(requestCount, this.expireTime.intValue());
        } else {
            KeyGenerator hitCount = AdxKeyGenerator.Risk.getRiskCrowdHitCount((String)date);
            this.counter.incrementAndGet(hitCount, this.expireTime.intValue());
        }
    }

    static class RiskCrowdHitData {
        private String date;
        private Long requestCount;
        private Long crowdHitCount;
        private Double hitRate;

        RiskCrowdHitData(String date, Long requestCount, Long crowdHitCount, Double hitRate) {
            this.date = date;
            this.requestCount = requestCount;
            this.crowdHitCount = crowdHitCount;
            this.hitRate = hitRate;
        }

        public static RiskCrowdHitDataBuilder builder() {
            return new RiskCrowdHitDataBuilder();
        }

        public String getDate() {
            return this.date;
        }

        public Long getRequestCount() {
            return this.requestCount;
        }

        public Long getCrowdHitCount() {
            return this.crowdHitCount;
        }

        public Double getHitRate() {
            return this.hitRate;
        }

        public void setDate(String date) {
            this.date = date;
        }

        public void setRequestCount(Long requestCount) {
            this.requestCount = requestCount;
        }

        public void setCrowdHitCount(Long crowdHitCount) {
            this.crowdHitCount = crowdHitCount;
        }

        public void setHitRate(Double hitRate) {
            this.hitRate = hitRate;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RiskCrowdHitData)) {
                return false;
            }
            RiskCrowdHitData other = (RiskCrowdHitData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$requestCount = this.getRequestCount();
            Long other$requestCount = other.getRequestCount();
            if (this$requestCount == null ? other$requestCount != null : !((Object)this$requestCount).equals(other$requestCount)) {
                return false;
            }
            Long this$crowdHitCount = this.getCrowdHitCount();
            Long other$crowdHitCount = other.getCrowdHitCount();
            if (this$crowdHitCount == null ? other$crowdHitCount != null : !((Object)this$crowdHitCount).equals(other$crowdHitCount)) {
                return false;
            }
            Double this$hitRate = this.getHitRate();
            Double other$hitRate = other.getHitRate();
            if (this$hitRate == null ? other$hitRate != null : !((Object)this$hitRate).equals(other$hitRate)) {
                return false;
            }
            String this$date = this.getDate();
            String other$date = other.getDate();
            return !(this$date == null ? other$date != null : !this$date.equals(other$date));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RiskCrowdHitData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $requestCount = this.getRequestCount();
            result = result * 59 + ($requestCount == null ? 43 : ((Object)$requestCount).hashCode());
            Long $crowdHitCount = this.getCrowdHitCount();
            result = result * 59 + ($crowdHitCount == null ? 43 : ((Object)$crowdHitCount).hashCode());
            Double $hitRate = this.getHitRate();
            result = result * 59 + ($hitRate == null ? 43 : ((Object)$hitRate).hashCode());
            String $date = this.getDate();
            result = result * 59 + ($date == null ? 43 : $date.hashCode());
            return result;
        }

        public String toString() {
            return "RiskCrowdHit.RiskCrowdHitData(date=" + this.getDate() + ", requestCount=" + this.getRequestCount() + ", crowdHitCount=" + this.getCrowdHitCount() + ", hitRate=" + this.getHitRate() + ")";
        }

        public static class RiskCrowdHitDataBuilder {
            private String date;
            private Long requestCount;
            private Long crowdHitCount;
            private Double hitRate;

            RiskCrowdHitDataBuilder() {
            }

            public RiskCrowdHitDataBuilder date(String date) {
                this.date = date;
                return this;
            }

            public RiskCrowdHitDataBuilder requestCount(Long requestCount) {
                this.requestCount = requestCount;
                return this;
            }

            public RiskCrowdHitDataBuilder crowdHitCount(Long crowdHitCount) {
                this.crowdHitCount = crowdHitCount;
                return this;
            }

            public RiskCrowdHitDataBuilder hitRate(Double hitRate) {
                this.hitRate = hitRate;
                return this;
            }

            public RiskCrowdHitData build() {
                return new RiskCrowdHitData(this.date, this.requestCount, this.crowdHitCount, this.hitRate);
            }

            public String toString() {
                return "RiskCrowdHit.RiskCrowdHitData.RiskCrowdHitDataBuilder(date=" + this.date + ", requestCount=" + this.requestCount + ", crowdHitCount=" + this.crowdHitCount + ", hitRate=" + this.hitRate + ")";
            }
        }
    }

    static class RiskCrowdData {
        private String content;
        private String type;

        public String getContent() {
            return this.content;
        }

        public String getType() {
            return this.type;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public void setType(String type) {
            this.type = type;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RiskCrowdData)) {
                return false;
            }
            RiskCrowdData other = (RiskCrowdData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$content = this.getContent();
            String other$content = other.getContent();
            if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RiskCrowdData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $content = this.getContent();
            result = result * 59 + ($content == null ? 43 : $content.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public String toString() {
            return "RiskCrowdHit.RiskCrowdData(content=" + this.getContent() + ", type=" + this.getType() + ")";
        }
    }
}

