/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.rule;

import com.bxm.adx.common.rule.Rule;
import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AndOrSetRule {
    private static final Logger log = LoggerFactory.getLogger(AndOrSetRule.class);
    private static final String OR_SPLIT = "/";
    private static final String AND_SPLIT = ",";
    private final Rule rule;
    private final String andSeparatorChars;
    private final String orSeparatorChars;

    public AndOrSetRule(Rule rule) {
        this(rule, AND_SPLIT, OR_SPLIT);
    }

    public AndOrSetRule(Rule rule, String andSeparatorChars, String orSeparatorChars) {
        this.rule = rule;
        this.andSeparatorChars = andSeparatorChars;
        this.orSeparatorChars = orSeparatorChars;
    }

    public Set<String> getAndParamNameSet() {
        String val = this.rule.getRuleValue();
        if (StringUtils.isEmpty((String)val)) {
            return Sets.newHashSet();
        }
        return Sets.newHashSet((Object[])val.split(this.andSeparatorChars));
    }

    public Set<String> getOrParamNameSet(String val) {
        if (StringUtils.isEmpty((String)val)) {
            return Sets.newHashSet();
        }
        return Sets.newHashSet((Object[])val.split(this.orSeparatorChars));
    }

    public boolean isOrParams(String val) {
        if (StringUtils.isEmpty((String)val)) {
            return false;
        }
        return val.contains(this.orSeparatorChars);
    }
}

