/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.rule;

import com.bxm.adx.common.rule.Rule;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WhiteBlackSetRule {
    private static final Logger log = LoggerFactory.getLogger(WhiteBlackSetRule.class);
    public static final String TYPE_WHITELIST = "1";
    public static final String TYPE_BLACKLIST = "2";
    private boolean white;
    private static final String GROUP_SPLIT = "-";
    private static final String SPLIT = ",";
    private final Rule rule;
    private final String groupSeparatorChars;
    private final String separatorChars;

    public WhiteBlackSetRule(Rule rule) {
        this(rule, GROUP_SPLIT, SPLIT);
    }

    public WhiteBlackSetRule(Rule rule, String groupSeparatorChars, String separatorChars) {
        this.rule = rule;
        this.groupSeparatorChars = groupSeparatorChars;
        this.separatorChars = separatorChars;
    }

    public Set<String> getSet() {
        String value = this.rule.getRuleValue();
        HashSet res = Sets.newHashSet();
        if (StringUtils.isBlank((String)value)) {
            return res;
        }
        int startIndex = value.indexOf(this.groupSeparatorChars);
        if (startIndex == -1) {
            log.warn("Invalid value for value: {}", (Object)value);
            return res;
        }
        String type = StringUtils.substring((String)value, (int)0, (int)startIndex);
        String array = StringUtils.substring((String)value, (int)(startIndex + 1), (int)value.length());
        this.white = StringUtils.equalsIgnoreCase((String)type, (String)TYPE_WHITELIST);
        return Sets.newHashSet((Object[])StringUtils.split((String)array, (String)this.separatorChars));
    }

    public boolean isWhite() {
        return this.white;
    }

    public static boolean isFilter(Rule rule, Collection<String> basic) {
        WhiteBlackSetRule wbsr = new WhiteBlackSetRule(rule);
        Set<String> defined = wbsr.getSet();
        boolean white = wbsr.isWhite();
        long count = defined.stream().filter(basic::contains).count();
        if (white) {
            return count == 0L;
        }
        return count > 0L;
    }
}

