/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.sell.position.mapping;

import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.PositionMappingProperties;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.position.Position;
import com.bxm.adx.common.sell.position.PositionChangeHandler;
import com.bxm.adx.common.sell.position.PositionService;
import com.bxm.adx.common.sell.position.mapping.PositionMappingStrategy;
import com.bxm.adx.common.sell.position.mapping.Strategy;
import com.bxm.adx.common.sell.request.Impression;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class PositionSizeStrategy
implements PositionMappingStrategy,
PositionChangeHandler {
    private final AdxProperties adxProperties;
    private final ConcurrentHashMap<String, Position> positionInfoMap = new ConcurrentHashMap();
    private final PositionService positionService;

    public PositionSizeStrategy(AdxProperties adxProperties, PositionService positionService) {
        this.adxProperties = adxProperties;
        this.positionService = positionService;
    }

    @Override
    public Strategy strategy() {
        return Strategy.Position_Size;
    }

    @Override
    public Position mapping(BidRequest bidRequest, Impression impression, PositionMappingProperties properties) {
        String appId = this.getAppId(bidRequest, properties);
        Position position = this.getPositionByInfo(appId, impression.getW(), impression.getH(), impression.getImp_type());
        return position;
    }

    public Position getPositionByInfo(String appId, Integer w, Integer h, Integer positionScene) {
        if (StringUtils.isEmpty((String)appId)) {
            return null;
        }
        if (Objects.isNull(w) || Objects.isNull(h)) {
            return null;
        }
        if (Objects.isNull(positionScene)) {
            return null;
        }
        String key = this.buildMapKey(appId, w, h, positionScene);
        return this.positionInfoMap.get(key);
    }

    private String getAppId(BidRequest bidRequest, PositionMappingProperties properties) {
        if (Objects.nonNull(bidRequest.getDevice()) && bidRequest.getDevice().isIos()) {
            return properties.getIosAppId();
        }
        return properties.getAndroidAppId();
    }

    @Override
    public void doUpdate(Position old, Position latest) {
        if (this.isExecuteUpdateAndDoDelete(old, latest)) {
            Strategy strategy = this.getStrategy(latest);
            switch (strategy) {
                case Position_Size: {
                    String infoKey = this.buildMapKeyByPosition(latest);
                    if (!StringUtils.isNotEmpty((String)infoKey)) break;
                    this.positionInfoMap.put(infoKey, latest);
                }
            }
        }
    }

    @Override
    public void doDelete(Position old) {
        Strategy strategy = this.getStrategy(old);
        switch (strategy) {
            case Position_Size: {
                String infoKey = this.buildMapKeyByPosition(old);
                if (!StringUtils.isNotEmpty((String)infoKey)) break;
                this.positionInfoMap.remove(infoKey);
            }
        }
    }

    private Strategy getStrategy(Position position) {
        String appId = position.getAppId();
        List<PositionMappingProperties> positionMapping = this.adxProperties.getPositionMapping();
        if (CollectionUtils.isEmpty(positionMapping)) {
            return Strategy.Default;
        }
        for (PositionMappingProperties pm : positionMapping) {
            if (!appId.equals(pm.getAndroidAppId()) && !appId.equals(pm.getIosAppId()) && !appId.equals(pm.getDefaultAppId())) continue;
            return pm.getStrategy();
        }
        return Strategy.Default;
    }

    public String buildMapKeyByPosition(Position position) {
        String appId = position.getAppId();
        String positionSize = position.getPositionSize();
        Byte scene = position.getPositionScene();
        if (StringUtils.isEmpty((String)appId)) {
            return null;
        }
        if (StringUtils.isEmpty((String)positionSize)) {
            return null;
        }
        if (Objects.isNull(scene)) {
            return null;
        }
        String size = positionSize.split(" ")[0];
        String val = appId + "-" + position.getPositionScene() + "-" + size;
        return val;
    }

    public String buildMapKey(String appId, int w, int h, int positionScene) {
        String val = appId + "-" + positionScene + "-" + w + "*" + h;
        return val;
    }
}

