/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.utils;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class DateUtils {
    public static final String PATTERN_SECOND = "yyyyMMdd HH:mm:ss";
    public static final String PATTERN_DATE = "yyyyMMdd";
    public static final DateTimeFormatter FORMAT_SIMPLE = DateTimeFormatter.ofPattern("yyyyMMdd");

    public static LocalDate convertDate(Date date) {
        Instant instant = date.toInstant();
        ZoneId zone = ZoneId.systemDefault();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zone);
        LocalDate localDate = localDateTime.toLocalDate();
        return localDate;
    }

    public static boolean isBetween(Date start, Date end) {
        LocalDate now = LocalDate.now();
        LocalDate s = DateUtils.convertDate(start);
        LocalDate e = DateUtils.convertDate(end);
        if (now.isAfter(s) && now.isBefore(e)) {
            return true;
        }
        return now.isEqual(s) || now.isEqual(e);
    }

    public static LocalDateTime convertLocalDateTime(String date) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(PATTERN_SECOND);
        LocalDateTime localDateTime = LocalDateTime.parse(date, formatter);
        return localDateTime;
    }

    public static DateTimeFormatter getDateTimeFormatter(String pattern) {
        return DateTimeFormatter.ofPattern(pattern);
    }

    public static long getDuration(Date date) {
        Date now = new Date();
        long differenceInMillis = now.getTime() - date.getTime();
        long differenceInMinutes = differenceInMillis / 60000L;
        return differenceInMinutes;
    }
}

