/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.utils;

import com.bxm.warcar.utils.JsonHelper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public final class ServletUtils {
    private static final Logger log = LoggerFactory.getLogger(ServletUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBodyForBuffer(HttpServletRequest request) {
        byte[] byArray;
        Object inputStream = null;
        ByteArrayOutputStream outputStream = null;
        try {
            inputStream = ServletUtils.isGzip(request) ? new GZIPInputStream((InputStream)request.getInputStream()) : request.getInputStream();
            outputStream = new ByteArrayOutputStream();
            int len = -1;
            byte[] buff = new byte[2048];
            while ((len = ((InputStream)inputStream).read(buff)) != -1) {
                outputStream.write(buff, 0, len);
            }
            outputStream.flush();
            byArray = outputStream.toByteArray();
        }
        catch (IOException e) {
            byte[] byArray2;
            try {
                if (log.isDebugEnabled()) {
                    log.debug("read request input stream occur error!", (Throwable)e);
                }
                byArray2 = new byte[]{};
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outputStream);
                IOUtils.closeQuietly((InputStream)inputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)outputStream);
            IOUtils.closeQuietly((InputStream)inputStream);
            return byArray2;
        }
        IOUtils.closeQuietly((OutputStream)outputStream);
        IOUtils.closeQuietly((InputStream)inputStream);
        return byArray;
    }

    public static void println(HttpServletResponse response, byte[] data, Map<String, String> header) {
        ServletUtils.println(response, data, header, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void println(HttpServletResponse response, byte[] data, Map<String, String> header, boolean closeStream) {
        ServletOutputStream out = null;
        try {
            if (!CollectionUtils.isEmpty(header)) {
                for (Map.Entry<String, String> entry : header.entrySet()) {
                    response.setHeader(entry.getKey(), entry.getValue());
                }
            }
            out = response.getOutputStream();
            if (data != null) {
                out.write(data);
            }
            out.flush();
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.debug("writer resp body err", (Throwable)e);
            }
        }
        finally {
            if (closeStream) {
                IOUtils.closeQuietly((OutputStream)out);
            }
        }
    }

    public static byte[] convert2JsonBytes(Map<String, String[]> map) {
        HashMap<String, String> map1 = new HashMap<String, String>(map.size());
        for (Map.Entry<String, String[]> stringEntry : map.entrySet()) {
            String strKey = stringEntry.getKey();
            String[] strObj = stringEntry.getValue();
            map1.put(strKey.toString(), strObj[0]);
        }
        return JsonHelper.convert2bytes(map1);
    }

    private static boolean isGzip(HttpServletRequest request) {
        String encoding = request.getHeader("Content-Encoding");
        return StringUtils.isNotEmpty((CharSequence)encoding) && "gzip".equalsIgnoreCase(encoding);
    }
}

