package com.bxm.adx.service;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.openfeign.EnableFeignClients;

import com.bxm.adx.service.common.autoconfigure.config.ApplicationGlobalConfig;
import com.bxm.warcar.configure.spring.SpringBootEnvironmentListener;

/**
 * 主程序<br/>
 *
 * @author kerry.jiang
 * @date 2019/12/24 11:18
 */
@SpringBootApplication
@EnableFeignClients("com.bxm.adxcounter.facade")
@EnableConfigurationProperties(ApplicationGlobalConfig.class)
public class AdxServiceApplication {

    public static void main(String[] args) {
        SpringApplication application = new SpringApplication(AdxServiceApplication.class);
        application.addListeners(new SpringBootEnvironmentListener());
        application.run(args);
    }
}
