package com.bxm.adx.service.common.api.adapter.wake;

import java.util.Collections;
import java.util.Map;
import java.util.Set;

import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

import com.google.common.collect.Maps;

/**
 * 适配器工厂<br/>
 *
 * @author kerry.jiang
 * @date 2019/10/31 15:34
 */
@Component
public class WakeAdapterFactory implements ApplicationListener<ApplicationPreparedEvent> {

    /**
     * 适配器容器
     */
    private static final Map<Integer, WakeAdapter> ADAPTER_MAP = Maps.newConcurrentMap();

    @Override
    public void onApplicationEvent(ApplicationPreparedEvent event) {
        ApplicationContext applicationContext = event.getApplicationContext();
        Map<String, WakeAdapter> beansOfType = applicationContext.getBeansOfType(WakeAdapter.class);
        Set<Map.Entry<String, WakeAdapter>> entries = beansOfType.entrySet();
        for (Map.Entry<String, WakeAdapter> entry : entries) {
            WakeAdapter service = entry.getValue();
            ADAPTER_MAP.put(service.getAdapterId().getValue(), service);
        }
    }

    /**
     * 获取适配器<br/>
     *
     * @param wakeCheckApi
     * @return com.bxm.adx.service.common.api.adapter.wake.WakeAdapter
     */
    public static WakeAdapter getAdapter(Integer wakeCheckApi) {
        return ADAPTER_MAP.get(wakeCheckApi);
    }

    /**
     * 获取适配器<br/>
     *
     * @param wakeCheckApiEnum
     * @return com.bxm.adx.service.common.api.adapter.wake.WakeAdapter
     */
    public static WakeAdapter getAdapter(WakeCheckApiEnum wakeCheckApiEnum) {
        return ADAPTER_MAP.get(wakeCheckApiEnum.getValue());
    }

    /**
     * 获取所有适配器<br/>
     *
     * @return java.util.Map<java.lang.Integer,com.bxm.adx.service.common.api.adapter.wake.WakeAdapter>
     */
    public static Map<Integer, WakeAdapter> getAdApterMap() {
        return Collections.unmodifiableMap(ADAPTER_MAP);
    }
}
