package com.bxm.adx.service.common.api.adapter.wake;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

import com.bxm.adx.facade.model.task.TaskInfoRequest;

import lombok.extern.slf4j.Slf4j;

@Slf4j
@Component
public class WakeAdapterHandleImpl implements WakeAdapterHandle {

    @Override
    public Boolean isWakeUser(Integer wakeCheckApi, TaskInfoRequest request) {
        WakeAdapter adapter = WakeAdapterFactory.getAdapter(wakeCheckApi);
        WakeResponse rs = adapter.getWakeUser(of(request));
        if(null == rs || CollectionUtils.isEmpty(rs.getDevNos())){
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    /**
     * 信息转换
     */
    private WakeRequest of(TaskInfoRequest request){
        WakeRequest rq = new WakeRequest();
        rq.setOs(request.getOs());
        rq.setIdfa(request.getIdfa());
        rq.setImei(request.getImei());
        rq.setAnid(request.getAnid());
        return rq;
    }
}
