package com.bxm.adx.service.common.api.tencent;

import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.*;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

import com.alibaba.fastjson.JSON;
import com.bxm.warcar.utils.JsonHelper;

/**
 * 腾讯新闻API<br/>
 *
 * @author kerry.jiang
 * @date 2020/7/21 11:02
 */
public class TencentNewsApi {

    private final static Logger LOGGER = LoggerFactory.getLogger(TencentNewsApi.class);

    /**
     * 参数名称
     */
    private static String SOURCE = "source";
    private static String MARK = "mark";
    private static String IDS = "ids";
    private static String TIMESTAMP = "timestamp";
    private static String SIGN = "sign";

    /**
     * 头信息
     */
    private static HttpHeaders headers = new HttpHeaders();
    /**
     * 接口地址
     */
    protected String api_url;

    static {
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
    }

    public TencentNewsApi(String api_url){
        this.api_url = api_url;
    }

    /**
     * 用户唤醒查询
     * @param request
     * @param restTemplate
     * @return
     */
    public TencentNewsWakeResponse getWakeUser(RestTemplate restTemplate, TencentNewsWakeRequest request){
        MultiValueMap<String, String> postParameters = getParameters(request);
        HttpEntity httpEntity = new HttpEntity(postParameters, headers);
        ResponseEntity<String> responseEntity = null;
        try {
            responseEntity = restTemplate.postForEntity(this.api_url, httpEntity, String.class);
        }catch (ResourceAccessException e){//超时不记录日志
            if(LOGGER.isDebugEnabled()){
                LOGGER.debug("getWakeUser timeout:paramJson={}", JsonHelper.convert(request));
            }
            return null;
        }catch (Exception e){
            LOGGER.error("getWakeUser error: paramJson={},e={}", JsonHelper.convert(request), ExceptionUtils.getFullStackTrace(e));
            return null;
        }
        HttpStatus httpStatus = responseEntity.getStatusCode();
        if(HttpStatus.OK == httpStatus){
            TencentNewsWakeResponse response = JsonHelper.convert(responseEntity.getBody(), TencentNewsWakeResponse.class);
            if(null == response || !response.sucess()){
                LOGGER.warn("getWakeUser warn: paramJson={}, response={}", JsonHelper.convert(request), response);
            }
            return response;
        }else{
            LOGGER.warn("getWakeUser warn: httpStatus={}, paramJson={}", httpStatus.value(), JsonHelper.convert(request));
            return null;
        }
    }

    /**
     * 获取参数
     */
    private MultiValueMap<String, String> getParameters(TencentNewsWakeRequest request){
        MultiValueMap<String, String> postParameters = new LinkedMultiValueMap<>();
        String timestamp = ""+(System.currentTimeMillis()/1000);
        String sign = DigestUtils.md5Hex(StringUtils.join(request.getSource(), timestamp, request.getKey()));
        postParameters.add(SOURCE, request.getSource());
        postParameters.add(MARK, request.getMark());
        postParameters.add(IDS, JSON.toJSONString(request.getIds()));
        postParameters.add(TIMESTAMP, timestamp);//10位数时间戳（秒）
        postParameters.add(SIGN, sign);//md5(source+timestamp+key)
        return postParameters;
    }
}
