package com.bxm.adx.service.common.convert;

import com.bxm.adx.facade.rule.task.Task;
import com.bxm.adx.facade.rule.task.TaskOfRules;
import com.bxm.adx.facade.rule.task.TaskCache;
import com.google.common.base.Preconditions;

/**
 * 任务信息转换<br/>
 *
 * @author kerry.jiang
 * @date 2020/3/25 19:36
 */
public final class TaskConvert {

    private TaskConvert() {}

    /**
     * 全部的数据
     */
    public static Task of(TaskOfRules orig) {
        Preconditions.checkNotNull(orig);
        Task dest = new Task();
        dest.setId(orig.getId());
        dest.setName(orig.getName());
        dest.setStartDate(orig.getStartDate());
        dest.setEndDate(orig.getEndDate());
        dest.setType(orig.getType());
        dest.setViewTotalLimit(orig.getViewTotalLimit());
        dest.setViewDayLimit(orig.getViewDayLimit());
        dest.setClickTotalLimit(orig.getClickTotalLimit());
        dest.setClickDayLimit(orig.getClickDayLimit());
        dest.setWakeUpTotalLimit(orig.getWakeUpTotalLimit());
        dest.setWakeUpDayLimit(orig.getWakeUpDayLimit());
        dest.setViewClickInterval(orig.getViewClickInterval());
        dest.setWakeUpToDesktop(orig.getWakeUpToDesktop());
        dest.setPackageName(orig.getPackageName());
        dest.setJumpProtocol(orig.getJumpProtocol());
        dest.setAcquireMonitorUrl(orig.getAcquireMonitorUrl());
        dest.setViewMonitorUrl(orig.getViewMonitorUrl());
        dest.setClickMonitorUrl(orig.getClickMonitorUrl());
        dest.setReadyMonitorUrl(orig.getReadyMonitorUrl());
        dest.setWakeUpMonitorUrl(orig.getWakeUpMonitorUrl());
        dest.setWakeSucceedMonitorUrl(orig.getWakeSucceedMonitorUrl());
        dest.setOs(orig.getOs());
        dest.setPriority(orig.getPriority());
        dest.setStatus(orig.getStatus());
        dest.setPauseReason(orig.getPauseReason());
        return dest;
    }

    /**
     * 开放中的数据
     */
    public static TaskCache ofOpened(TaskOfRules orig) {
        Preconditions.checkNotNull(orig);
        TaskCache dest = new TaskCache();
        dest.setId(orig.getId());
        dest.setStartDate(orig.getStartDate());
        dest.setEndDate(orig.getEndDate());
        dest.setType(orig.getType());
        dest.setViewTotalLimit(orig.getViewTotalLimit());
        dest.setViewDayLimit(orig.getViewDayLimit());
        dest.setClickTotalLimit(orig.getClickTotalLimit());
        dest.setClickDayLimit(orig.getClickDayLimit());
        dest.setWakeUpTotalLimit(orig.getWakeUpTotalLimit());
        dest.setWakeUpDayLimit(orig.getWakeUpDayLimit());
        dest.setViewClickInterval(orig.getViewClickInterval());
        dest.setWakeUpToDesktop(orig.getWakeUpToDesktop());
        dest.setPackageName(orig.getPackageName());
        dest.setJumpProtocol(orig.getJumpProtocol());
        dest.setWakeCheckApi(orig.getWakeCheckApi());
        dest.setAcquireMonitorUrl(orig.getAcquireMonitorUrl());
        dest.setViewMonitorUrl(orig.getViewMonitorUrl());
        dest.setClickMonitorUrl(orig.getClickMonitorUrl());
        dest.setReadyMonitorUrl(orig.getReadyMonitorUrl());
        dest.setWakeUpMonitorUrl(orig.getWakeUpMonitorUrl());
        dest.setWakeSucceedMonitorUrl(orig.getWakeSucceedMonitorUrl());
        dest.setOs(orig.getOs());
        dest.setPriority(orig.getPriority());
        return dest;
    }
}
