package com.bxm.adx.service.common.pushable;

import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

import com.bxm.adx.facade.constant.redis.AdxKeyGenerator;
import com.bxm.adx.facade.rule.task.TaskCache;
import com.bxm.adx.facade.rule.task.TaskOfRules;
import com.bxm.adx.service.common.convert.TaskConvert;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.cache.push.Pushable;
import com.bxm.warcar.utils.JsonHelper;

import lombok.extern.slf4j.Slf4j;

/**
 * 推送接收器-开放中的任务信息<br/>
 *
 * @author kerry.jiang
 * @date 2020/3/26 19:21
 */
@Component
@Slf4j
public class TaskOpenedPushable implements Pushable {

    @Autowired
    @Qualifier("jedisUpdater")
    private Updater updater;

    @Override
    public void push(Map<String, Object> parameters, byte[] data) {
        TaskOfRules rules = JsonHelper.convert(data, TaskOfRules.class);
        String taskId = String.valueOf(rules.getId());
        KeyGenerator keyGenerator = AdxKeyGenerator.Task.getOpenedList();
        if (rules.isOpened()) {
            TaskCache cache = TaskConvert.ofOpened(rules);
            updater.hupdate(keyGenerator, taskId, cache);
        }else{
            updater.hremove(keyGenerator, taskId);
        }
    }
}
