package com.bxm.adx.service.common.sifter;

import java.util.Map;

import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.util.ClassUtils;

import com.bxm.warcar.integration.interceptor.Interceptor;
import com.bxm.warcar.integration.sifter.AbstractSifter;
import com.google.common.collect.Maps;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.binder.MeterBinder;
import lombok.extern.slf4j.Slf4j;

/**
 * 筛选者监控<br/>
 *
 * @author kerry.jiang
 * @date 2020/4/10 14:23
 */
@Slf4j
public class SifterMeter implements MeterBinder, ApplicationListener<ApplicationReadyEvent> {

    private final Map<Class, Timer> timer = Maps.newHashMap();

    private Iterable<AbstractSifter> sifters;
    private MeterRegistry registry;

    @Override
    public void onApplicationEvent(ApplicationReadyEvent event) {
        this.sifters = event.getApplicationContext().getBeansOfType(AbstractSifter.class).values();
        this.initTimers();
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        this.registry = registry;
    }

    public Timer getTimer(Interceptor interceptor) {
        return timer.get(ClassUtils.getUserClass(interceptor.getClass()));
    }

    /**
     * 初始化分时模型
     */
    private void initTimers() {
        for (AbstractSifter sifter : sifters) {
            Class<?> clazz = ClassUtils.getUserClass(sifter.getClass());
            Timer timer = Timer.builder("task.sifter")
                    .tags("name", clazz.getName())
                    .register(registry);
            this.timer.put(clazz, timer);
            if (log.isInfoEnabled()) {
                log.info("Bind filter {} to MeterRegistry", clazz);
            }
        }
    }
}
