package com.bxm.adx.service.common.sifter.task;

import java.util.Date;
import java.util.Objects;

import org.springframework.stereotype.Component;

import com.bxm.adx.facade.model.task.TaskInfoRequest;
import com.bxm.adx.facade.rule.task.TaskCache;
import com.bxm.warcar.integration.sifter.Context;

import lombok.extern.slf4j.Slf4j;

/**
 * 可用性<br/>
 *
 * @author kerry.jiang
 * @date 2020/3/26 20:40
 */
@Component
@Slf4j
public class TaskAvailableSifter extends TaskAbstractSifter {

    @Override
    public boolean filter(Context<TaskData> context) {
        TaskInfoRequest request = context.getData().getRequest();
        TaskCache data = context.getData().getTaskCache();
        if(null != request.getTaskType() && !Objects.equals(data.getType(), request.getTaskType())){
            super.addReason(context, "任务类型不匹配");
            return true;
        }
        //TODO 目前不验证日期    
//        if (filterDate(context, data)){
//            return true;
//        }
        return false;
    }

    /**
     * 日期过滤
     */
    private boolean filterDate(Context<TaskData> context, TaskCache data) {
        Date today = context.getData().getChainData().getToday();
        if(null != data.getStartDate() && data.getStartDate().compareTo(today) > 0){
            super.addReason(context, "任务未开始");
            return true;
        }
        if(null != data.getEndDate() && today.compareTo(data.getEndDate()) > 0){
            super.addReason(context, "任务已结束");
            return true;
        }
        return false;
    }
}
