package com.bxm.adx.service.common.sifter.task;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSON;
import com.bxm.adx.facade.constant.redis.AdxKeyGenerator;
import com.bxm.adx.facade.rule.task.TaskCache;
import com.bxm.adx.facade.rule.task.TaskDeviceBrandRuleSo;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.integration.sifter.Context;

import lombok.extern.slf4j.Slf4j;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;

/**
 * 设备品牌定向<br/>
 *
 * @author kerry.jiang
 * @date 2020/6/1 15:40
 */
@Component
@Slf4j
public class TaskDeviceBrandSifter extends TaskAbstractSifter {

    @Autowired
    @Qualifier("jedisFetcher")
    private Fetcher fetcher;
    
    @Override
    public boolean filter(Context<TaskData> context) {
        if(StringUtils.isEmpty(context.getData().getChainData().getDevb())){
            return false;
        }
        //填充品牌黑白名单信息
        fillDeviceBrand(context);
        
        //品牌黑白名单限制
        if(filterDeviceBrand(context)){
            return true;
        }
        
        return false;
    }

    /**
     * 品牌黑白名单限制
     */
    private boolean filterDeviceBrand(Context<TaskData> context) {
        String devb = context.getData().getChainData().getDevb();
        TaskCache data = context.getData().getTaskCache();
        TaskDeviceBrandRuleSo rule = context.getData().getMapDeviceBrandRule().get(data.getId());
        if(null == rule || CollectionUtils.isEmpty(rule.getDeviceBrands())){
            return false;
        }

        boolean blackList = rule.isBlackList();
        Set<String> list = rule.getDeviceBrands();
        if(blackList){//黑名单
            if(list.contains(devb)){
                super.addReason(context, "在设备品牌黑名单");
                return true;
            }
        }else{//白名单
            if(!list.contains(devb)){
                super.addReason(context, "不在设备品牌白名单");
                return true;
            }
        }
        return false;
    }

    /**
     * 填充品牌黑白名单信息
     */
    private void fillDeviceBrand(Context<TaskData> context) {
        TaskData data = context.getData();
        TaskChainData chainData = data.getChainData();
        if(Boolean.TRUE.equals(data.getFlagDeviceBrand())){//取值标识判断
            return ;
        }
        List<Long> ids = super.getIds(context);
        if(CollectionUtils.isEmpty(ids)){
            return;
        }

        Map<Long, TaskDeviceBrandRuleSo> mapDeviceBrandRule = new HashMap<>();
        data.setFlagDeviceBrand(Boolean.TRUE);//取值标识变更
        data.setMapDeviceBrandRule(mapDeviceBrandRule);

        JedisPool jedisPool = (JedisPool)fetcher.getClientOriginal();
        Jedis jedis = null;
        Map<Long, Response<String>> mapDeviceBrandRuleRs = new HashMap<>();
        try {
            jedis = jedisPool.getResource();
            Pipeline pipeline = jedis.pipelined();
            for (Long id : ids) {
                mapDeviceBrandRuleRs.put(id, pipeline.get(AdxKeyGenerator.Task.getDeviceBrandRule(id).generateKey()));
            }
            pipeline.syncAndReturnAll();
        } catch (Exception e){
            log.error("fillDeviceBrand error: ids={},e={}",
                    ids, ExceptionUtils.getFullStackTrace(e));
        } finally {
            if (null != jedis) {
                jedis.close();
            }
        }

        //填充广告位黑白名单信息
        fillDeviceBrand(mapDeviceBrandRule, mapDeviceBrandRuleRs);
    }

    /**
     * 填充广告位黑白名单信息
     */
    private void fillDeviceBrand(Map<Long, TaskDeviceBrandRuleSo> mapDeviceBrandRule, Map<Long, Response<String>> mapDeviceBrandRuleRs) {
        Set<Long> keySet = mapDeviceBrandRuleRs.keySet();
        for (Long id : keySet) {
            Response<String> strRs = mapDeviceBrandRuleRs.get(id);
            String str = strRs.get();//黑白名单信息
            if(StringUtils.isBlank(str)){
                continue;
            }
            mapDeviceBrandRule.put(id, JSON.parseObject(str, TaskDeviceBrandRuleSo.class));
        }
    }
    
}
