package com.bxm.adx.service.common.sifter.task;

import java.util.Map;
import java.util.Objects;

import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.stereotype.Component;

import com.bxm.adx.facade.constant.enums.TaskTypeEnum;
import com.bxm.adx.facade.constant.redis.GlobalConfigField;
import com.bxm.adx.facade.constant.redis.TaskCounterField;
import com.bxm.adx.facade.rule.task.TaskCache;
import com.bxm.warcar.integration.sifter.Context;

import lombok.extern.slf4j.Slf4j;

/**
 * 全局限制<br/>
 *
 * @author kerry.jiang
 * @date 2020/7/14 15:09
 */
@Component
@Slf4j
public class TaskGlobalSifter extends TaskAbstractSifter {

    @Override
    public boolean filter(Context<TaskData> context) {

        //设备频次限制
        if(filterFrequency(context)){
            return true;
        }

        return false;
    }

    /**
     * 设备频次限制
     */
    private boolean filterFrequency(Context<TaskData> context) {
        TaskCache data = context.getData().getTaskCache();
        if(!Objects.equals(data.getType(), TaskTypeEnum.SILENCE_WAKE.getId())){
            //不是静默唤醒任务
            return false;
        }
        TaskChainData chainData = context.getData().getChainData();
        Map<String, String> mapConf = chainData.getMapGlobalConfig();
        Map<String, String> mapDevCounterToday = chainData.getMapDevCounterToday();
        if(MapUtils.isEmpty(mapConf) || MapUtils.isEmpty(mapDevCounterToday)){
            return false;
        }

        //单设备当日最大唤醒数限制
        String maximumTimesForDayStr = mapConf.get(GlobalConfigField.MAXIMUM_TIMES_FOR_DAY);
        if(StringUtils.isNotBlank(maximumTimesForDayStr)){
            Long wakes = NumberUtils.toLong(mapDevCounterToday.get(TaskCounterField.WAKES), 0);
            Long maximumTimesForDay = Long.valueOf(maximumTimesForDayStr);
            if(wakes >= maximumTimesForDay){
                //被限制：每个用户每天最多唤醒多少次静默唤醒任务
                super.addReason(context, "单设备当日最大唤醒数限制");
                return true;
            }
        }
        return false;
    }
}
