package com.bxm.adx.service.common.sifter.task;

import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

import com.bxm.adx.facade.rule.task.TaskCache;
import com.bxm.warcar.integration.sifter.Context;

import lombok.extern.slf4j.Slf4j;

/**
 * 已安装的APP包名<br/>
 *
 * @author kerry.jiang
 * @date 2020/6/1 14:37
 */
@Component
@Slf4j
public class TaskInstalledAppSifter extends TaskAbstractSifter {
    
    @Override
    public boolean filter(Context<TaskData> context) {
        List<String> pkns = context.getData().getChainData().getPkns();
        TaskCache data = context.getData().getTaskCache();
        if(CollectionUtils.isEmpty(pkns) || StringUtils.isEmpty(data.getPackageName())){
            return false;
        }
        
        if(!pkns.contains(data.getPackageName().trim())){
            super.addReason(context, "应用包未安装");
            return true;
        }
        
        return false;
    }
    
}
