package com.bxm.adx.service.common.sifter.task;

import java.util.Objects;

import org.springframework.stereotype.Component;

import com.bxm.adx.facade.model.task.TaskInfoRequest;
import com.bxm.adx.facade.rule.task.TaskCache;
import com.bxm.warcar.integration.sifter.Context;

import lombok.extern.slf4j.Slf4j;

/**
 * 系统定向<br/>
 *
 * @author kerry.jiang
 * @date 2020/3/26 20:40
 */
@Component
@Slf4j
public class TaskOsSifter extends TaskAbstractSifter {

    @Override
    public boolean filter(Context<TaskData> context) {
        TaskInfoRequest request = context.getData().getRequest();
        TaskCache data = context.getData().getTaskCache();
        if(null == request.getOs()){
            super.addReason(context, "系统类型不明确");
            return true;
        }
        if(!Objects.equals(data.getOs(), request.getOs())){
            super.addReason(context, "系统类型不匹配");
            return true;
        }
        return false;
    }
}
