package com.bxm.adx.service.common.sifter.task;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

import com.bxm.adx.facade.model.task.TaskInfoRequest;
import com.bxm.adx.facade.rule.task.TaskCache;
import com.bxm.adx.service.service.DevService;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.integration.sifter.Context;

import lombok.extern.slf4j.Slf4j;

/**
 * 耍呗筛选链<br/>
 * 获取单一任务<br/>
 *
 * @author kerry.jiang
 * @date 2020/3/26 20:40
 */
@Component
@Slf4j
public class TaskSifterForSingleChain extends TaskSifterSupperChain implements ApplicationListener<ApplicationPreparedEvent> {

    @Autowired
    @Qualifier("jedisFetcher")
    private Fetcher fetcher;
    @Autowired
    private DevService devService;

    @Autowired
    private TaskGlobalSifter taskGlobalSifter;
    @Autowired
    private TaskTimeSlotSifter taskTimeSlotSifter;
    @Autowired
    private TaskOsSifter taskOsSifter;
    @Autowired
    private TaskAvailableSifter taskAvailableSifter;
    @Autowired
    private TaskAppSifter taskAppSifter;
    @Autowired
    private TaskPositionSifter taskPositionSifter;
    @Autowired
    private TaskRegionSifter taskRegionSifter;
    @Autowired
    private TaskCounterSifter taskCounterSifter;
    @Autowired
    private TaskFrequencySifter taskFrequencySifter;
    @Autowired
    private TaskDeviceBrandSifter taskDeviceBrandSifter;
    @Autowired
    private TaskInstalledAppSifter taskInstalledAppSifter;
    @Autowired
    private TaskWakeAllowSifter taskWakeAllowSifter;

    @Override
    public void onApplicationEvent(ApplicationPreparedEvent event) {
        super.sifterList.add(taskGlobalSifter);
        super.sifterList.add(taskTimeSlotSifter);
        super.sifterList.add(taskOsSifter);
        super.sifterList.add(taskAvailableSifter);
        super.sifterList.add(taskAppSifter);
//        super.sifterList.add(taskPositionSifter);
        super.sifterList.add(taskRegionSifter);
        super.sifterList.add(taskCounterSifter);
        super.sifterList.add(taskFrequencySifter);
        super.sifterList.add(taskDeviceBrandSifter);
        super.sifterList.add(taskInstalledAppSifter);

        //放最后
        super.sifterList.add(taskWakeAllowSifter);
    }

    /**
     * 执行筛选过滤
     * 
     * @param request
     * @param list
     * @return
     */
    public TaskCache filter(TaskInfoRequest request, List<TaskCache> list){
        //先排好序，找到第一个符合条件的信息就返回
        sort(list);
        //过滤参数
        Context<TaskData> context = new Context<TaskData>();
        TaskData data = new TaskData();
        context.setData(data);
        //处理参数
        handleParam(request, list, data);
        //填充全局变量
        fillGlobal(fetcher, devService, context);
        //分批次取值
//        data.setSize(100);

        if(log.isDebugEnabled()){
            log.debug("chainData={}", data.getChainData());
        }

        TaskCache resp = null;
        //执行过滤
        for(TaskCache info : list){
//            data.count();//计数，便于执行分批取值
            
            context.setId(info.getId().toString());
            data.setTaskCache(info);
            if(super.doing(context)){
                continue;
            }else{
                resp = info;
                break;
            }
        }
        if(log.isDebugEnabled()){
            log.debug("filterMessage={}", context.getMessage());
        }
        return resp;
    }
}
