package com.bxm.adx.service.common.sifter.task;

import java.util.*;

import org.apache.commons.lang3.StringUtils;

import com.bxm.adx.facade.constant.enums.DevOsEnum;
import com.bxm.adx.facade.constant.redis.AdxKeyGenerator;
import com.bxm.adx.facade.model.dev.DevRequest;
import com.bxm.adx.facade.model.dev.SdkInitCache;
import com.bxm.adx.facade.model.task.TaskInfoRequest;
import com.bxm.adx.facade.rule.task.TaskCache;
import com.bxm.adx.service.common.util.DevHelper;
import com.bxm.adx.service.service.DevService;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.integration.sifter.AbstractSifterChain;
import com.bxm.warcar.integration.sifter.Context;
import com.bxm.warcar.utils.DateHelper;

/**
 * 耍呗筛选链<br/>
 * 父类<br/>
 *
 * @author kerry.jiang
 * @date 2020/6/1 14:40
 */
public class TaskSifterSupperChain extends AbstractSifterChain {

    /**
     * 处理参数
     */
    protected void handleParam(TaskInfoRequest request, List<TaskCache> list, TaskData data) {
        data.setRequest(request);
        TaskChainData chainData = new TaskChainData();
        data.setChainData(chainData);
        //id列表
        List<Long> idList = new ArrayList<>();
        list.forEach(info -> {
            idList.add(info.getId());
        });
        chainData.setIds(idList);
        //日期
        Date today = new Date();
        chainData.setToday(today);
        chainData.setTodayYmd(DateHelper.format(today, DateHelper.PATTERN_STR8));
        //设备号
        String devNo = DevHelper.getUid(DevRequest.builder()
                .os(request.getOs())
                .imei(request.getImei())
                .anid(request.getAnid())
                .idfa(request.getIdfa())
                .build());
        chainData.setDevNo(devNo);
    }

    /**
     * 填充全局变量信息
     */
    protected void fillGlobal(Fetcher fetcher, DevService devService, Context<TaskData> context) {
        TaskChainData chainData = context.getData().getChainData();
        if(StringUtils.isNotEmpty(chainData.getDevNo())){
            //设备品牌
            SdkInitCache sdkCache = devService.getSdkInitByUid(chainData.getDevNo());
            if(null != sdkCache && null != sdkCache.getDevb()){
                //转小写
                chainData.setDevb(sdkCache.getDevb().toLowerCase());
            }
            //已安装app包名
            if(Objects.equals(context.getData().getRequest().getOs(), DevOsEnum.ANDROID.getId())){
                chainData.setPkns(devService.getInstalledListByUid(chainData.getDevNo()));
            }
        }

        //全局变量
        Map<String, String> mapGlobalConfig = fetcher.hfetchall(AdxKeyGenerator.getConfig(), String.class);
        chainData.setMapGlobalConfig(mapGlobalConfig);
        //用户当日统计信息
        KeyGenerator keyGenerator = AdxKeyGenerator.Task.getCounterForDev(chainData.getTodayYmd(), chainData.getDevNo());
        Map<String, String> mapDevCounterToday = fetcher.hfetchall(keyGenerator, String.class);
        chainData.setMapDevCounterToday(mapDevCounterToday);
    }

    /**
     * 排序
     */
    protected void sort(List<TaskCache> list) {
        list.sort((o1, o2) -> {
            if (null == o1 || null == o1.getPriority()) {
                return 1;
            }
            if (null == o2 || null == o2.getPriority()) {
                return -1;
            }
            if (Objects.equals(o1.getPriority(), o2.getPriority())) {
                return o1.getId().compareTo(o2.getId());
            } else {
                return o1.getPriority().compareTo(o2.getPriority());
            }
        });
    }
}
